/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.ValidSchemaRegistryOperation;
import java.util.Collections;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"magic", "principal", "subject", "allowedoperations"})
public class SubjectAclValue
extends SchemaRegistryAclValue {
    private static final int MAGIC_BYTE = 0;
    @NotEmpty
    private String subject;
    @ValidSchemaRegistryOperation(value=ValidSchemaRegistryOperation.SchemaRegistryOperationType.SUBJECT)
    private Set<SchemaRegistryResourceOperation> allowedOperations;

    public SubjectAclValue(@JsonProperty(value="principal") String principal, @JsonProperty(value="subject") String subject, @JsonProperty(value="allowedoperations") Set<SchemaRegistryResourceOperation> allowedOperations) {
        super(0, principal);
        this.subject = subject;
        this.allowedOperations = Collections.unmodifiableSet(allowedOperations);
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="allowedoperations")
    public Set<SchemaRegistryResourceOperation> getAllowedOperations() {
        return this.allowedOperations;
    }

    @JsonProperty(value="allowedoperations")
    public void setAllowedOperations(Set<SchemaRegistryResourceOperation> allowedOperations) {
        this.allowedOperations = Collections.unmodifiableSet(allowedOperations);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SubjectAclValue that = (SubjectAclValue)o;
        if (!this.subject.equals(that.subject)) {
            return false;
        }
        return this.allowedOperations.equals(that.allowedOperations);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.subject.hashCode();
        result = 31 * result + this.allowedOperations.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("principal=" + this.principal + ",");
        sb.append("subject=" + this.subject + ",");
        sb.append("allowedoperations=" + String.valueOf(this.allowedOperations) + "}");
        return sb.toString();
    }
}

