/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.tools;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.AclMessageSerializer;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.NoopKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclAuthorizerUtils;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclReaderThread;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclValue;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.tools.SchemaRegistryAclCommandOptions;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.glassfish.jersey.internal.util.ExceptionUtils;

public class SchemaRegistryAclCommand {
    static final Map<String, Set<SchemaRegistryResourceOperation>> EMPTY_MAP = new HashMap<String, Set<SchemaRegistryResourceOperation>>();
    static final Set<SchemaRegistryResourceOperation> EMPTY_SET = EnumSet.noneOf(SchemaRegistryResourceOperation.class);
    Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations = new ConcurrentHashMap<String, Map<String, Set<SchemaRegistryResourceOperation>>>();
    Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations = new ConcurrentHashMap<String, Set<SchemaRegistryResourceOperation>>();
    SchemaRegistryAclReaderThread aclReaderThread;
    SchemaRegistryAclAuthorizerUtils aclAuthorizerUtils;

    public static void main(String[] args) throws Exception {
        SchemaRegistryAclCommand aclCommand = new SchemaRegistryAclCommand();
        SchemaRegistryAclCommandOptions schemaRegistryAclCommandOptions = new SchemaRegistryAclCommandOptions(args);
        schemaRegistryAclCommandOptions.parseAndValidateArgs();
        aclCommand.processCommand(schemaRegistryAclCommandOptions);
    }

    void processCommand(SchemaRegistryAclCommandOptions options) throws Exception {
        try {
            this.readAcl(options, this.subjectAllowedOperations, this.globalAllowedOperations);
            if (options.isListCommand()) {
                this.listAcl();
            } else if (options.isAddCommand()) {
                this.addAcl(options);
            } else if (options.isRemoveCommand()) {
                this.removeAcl(options);
            }
            this.aclReaderThread.shutdown();
            this.aclAuthorizerUtils.shutdown();
        }
        catch (Exception e) {
            options.printUsageAndDie("Error processing the ACL command:" + e.getMessage() + System.lineSeparator() + ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
        }
    }

    void addAcl(SchemaRegistryAclCommandOptions options) throws Exception {
        HashMap<SchemaRegistryAclKey, SchemaRegistryAclValue> aclValueMap = new HashMap<SchemaRegistryAclKey, SchemaRegistryAclValue>();
        this.processSubjectOperations(options, this.subjectAllowedOperations, aclValueMap, true);
        this.processGlobalOperations(options, this.globalAllowedOperations, aclValueMap, true);
        this.publishAcl(options.getConfig(), aclValueMap);
    }

    void removeAcl(SchemaRegistryAclCommandOptions options) throws Exception {
        HashMap<SchemaRegistryAclKey, SchemaRegistryAclValue> aclValueMap = new HashMap<SchemaRegistryAclKey, SchemaRegistryAclValue>();
        this.processSubjectOperations(options, this.subjectAllowedOperations, aclValueMap, false);
        this.processGlobalOperations(options, this.globalAllowedOperations, aclValueMap, false);
        this.publishAcl(options.getConfig(), aclValueMap);
    }

    void listAcl() {
        System.out.println("Current ACL's for Subject Operations are " + System.lineSeparator() + String.valueOf(this.subjectAllowedOperations));
        System.out.println("Current ACL's for Global Operations are " + System.lineSeparator() + String.valueOf(this.globalAllowedOperations));
    }

    void publishAcl(SecureSchemaRegistryConfig config, Map<SchemaRegistryAclKey, SchemaRegistryAclValue> aclValueMap) throws Exception {
        String topic = config.aclTopic();
        AclMessageSerializer serializer = new AclMessageSerializer();
        Properties props = new Properties();
        KafkaStore.addSchemaRegistryConfigsToClientProperties((SchemaRegistryConfig)config, (Properties)props);
        props.put("bootstrap.servers", config.bootstrapBrokers());
        props.put("acks", "-1");
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        props.put("retries", (Object)0);
        props.put("enable.idempotence", (Object)false);
        props.put("security.protocol", config.getString("kafkastore.security.protocol"));
        KafkaProducer producer = new KafkaProducer(props);
        Future ack = null;
        for (Map.Entry<SchemaRegistryAclKey, SchemaRegistryAclValue> aclEntry : aclValueMap.entrySet()) {
            ProducerRecord producerRecord = new ProducerRecord(topic, Integer.valueOf(0), (Object)serializer.serializeSchemaRegistryAclKey(aclEntry.getKey()), (Object)serializer.serializeSchemaRegistryAclValue(aclEntry.getValue()));
            ack = producer.send(producerRecord);
        }
        if (ack != null) {
            int timeout = config.getInt("kafkastore.init.timeout.ms");
            RecordMetadata metadata = (RecordMetadata)ack.get(timeout, TimeUnit.MILLISECONDS);
            this.aclReaderThread.waitUntilOffset(metadata.offset(), timeout, TimeUnit.MILLISECONDS);
        }
        producer.close();
    }

    void readAcl(SchemaRegistryAclCommandOptions options, Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations, Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations) throws StoreInitializationException, StoreException {
        NoopKey noopKey = new NoopKey();
        AclMessageSerializer aclMessageSerializer = new AclMessageSerializer();
        SecureSchemaRegistryConfig config = options.getConfig();
        int initTimeout = config.getInt("kafkastore.init.timeout.ms");
        this.aclAuthorizerUtils = new SchemaRegistryAclAuthorizerUtils(config, config.aclTopic(), initTimeout, config.bootstrapBrokers(), aclMessageSerializer, noopKey);
        this.aclAuthorizerUtils.createOrVerifySchemaTopic();
        this.aclReaderThread = new SchemaRegistryAclReaderThread(config, config.bootstrapBrokers(), config.aclTopic(), noopKey, aclMessageSerializer, "sr-acl-cli", subjectAllowedOperations, globalAllowedOperations);
        this.aclReaderThread.start();
        this.waitUntilKafkaReaderReachesLastOffset(initTimeout, this.aclAuthorizerUtils);
    }

    private void processSubjectOperations(SchemaRegistryAclCommandOptions options, Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations, Map<SchemaRegistryAclKey, SchemaRegistryAclValue> aclValueMap, boolean add) {
        if (options.hasSubjectOperations()) {
            for (String principal : options.getPrincipals()) {
                for (String subject : options.getSubjects()) {
                    Set<SchemaRegistryResourceOperation> existingOperations = this.getOrDefault(this.getOrDefault(subjectAllowedOperations, principal, EMPTY_MAP), subject, EMPTY_SET);
                    HashSet<SchemaRegistryResourceOperation> requestedSubjectOperations = new HashSet<SchemaRegistryResourceOperation>(options.getRequestedOperations());
                    requestedSubjectOperations.retainAll(SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS);
                    EnumSet<SchemaRegistryResourceOperation> newOperations = EnumSet.copyOf(existingOperations);
                    if (add) {
                        newOperations.addAll(requestedSubjectOperations);
                    } else {
                        newOperations.removeAll(requestedSubjectOperations);
                    }
                    aclValueMap.put(new SubjectAclKey(principal, subject), new SubjectAclValue(principal, subject, newOperations));
                }
            }
        }
    }

    private void processGlobalOperations(SchemaRegistryAclCommandOptions options, Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations, Map<SchemaRegistryAclKey, SchemaRegistryAclValue> aclValueMap, boolean add) {
        if (options.hasGlobalOperations()) {
            for (String principal : options.getPrincipals()) {
                Set<SchemaRegistryResourceOperation> existingOperations = this.getOrDefault(globalAllowedOperations, principal, EMPTY_SET);
                EnumSet<SchemaRegistryResourceOperation> newOperations = EnumSet.copyOf(existingOperations);
                HashSet<SchemaRegistryResourceOperation> requestedGlobalOperations = new HashSet<SchemaRegistryResourceOperation>(options.getRequestedOperations());
                requestedGlobalOperations.retainAll(SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS);
                if (add) {
                    newOperations.addAll(requestedGlobalOperations);
                } else {
                    newOperations.removeAll(requestedGlobalOperations);
                }
                aclValueMap.put(new GlobalAclKey(principal), new GlobalAclValue(principal, newOperations));
            }
        }
    }

    private void waitUntilKafkaReaderReachesLastOffset(int timeoutMs, SchemaRegistryAclAuthorizerUtils aclAuthorizerUtils) throws StoreException {
        long offsetOfLastMessage = aclAuthorizerUtils.getLatestOffset(timeoutMs);
        this.aclReaderThread.waitUntilOffset(offsetOfLastMessage, timeoutMs, TimeUnit.MILLISECONDS);
    }

    <T> T getOrDefault(Map<String, T> map, String key, T def) {
        return map.containsKey(key) ? map.get(key) : def;
    }
}

