/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestDataJsonConverter;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalAlterRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(IncrementalAlterRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        IncrementalAlterConfigsRequestData alterConfigsRequestData = IncrementalAlterConfigsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        IncrementalAlterConfigsResponseData alterConfigsResponseData = IncrementalAlterConfigsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean hasAuthorizationFailure = IncrementalAlterRequestAuditExtractor.hasAuthorizationFailure(alterConfigsResponseData);
        boolean validateOnly = alterConfigsRequestData.validateOnly();
        Struct requestData = IncrementalAlterRequestAuditExtractor.requestData(alterConfigsRequestData, requestEvent);
        Result.Status status = IncrementalAlterRequestAuditExtractor.status(alterConfigsResponseData);
        Struct resultData = IncrementalAlterRequestAuditExtractor.resultData(alterConfigsResponseData, requestEvent);
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        String resourceCrn = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
        extractedAuditLogs.add(auditLog);
        return extractedAuditLogs;
    }

    private static boolean hasAuthorizationFailure(IncrementalAlterConfigsResponseData alterConfigsResponseData) {
        return alterConfigsResponseData.responses().stream().anyMatch(alterConfigsResource -> AuditLogUtils.hasAuthorizationFailure(alterConfigsResource.errorCode()));
    }

    private static Struct requestData(IncrementalAlterConfigsRequestData alterConfigsRequestData, KafkaRequestEvent requestEvent) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)IncrementalAlterConfigsRequestDataJsonConverter.write((IncrementalAlterConfigsRequestData)alterConfigsRequestData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        for (JsonNode resource : jsonNode.get("resources")) {
            ((ObjectNode)resource).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)resource.get("resourceType").shortValue())).name()));
            for (JsonNode config : resource.get("configs")) {
                ((ObjectNode)config).set("configOperation", (JsonNode)new TextNode(AlterConfigOp.OpType.forId((byte)((byte)config.get("configOperation").shortValue())).name()));
            }
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(IncrementalAlterConfigsResponseData alterConfigsResponseData) {
        if (alterConfigsResponseData.responses().stream().anyMatch(alterConfigsResourceResponse -> alterConfigsResourceResponse.errorCode() != Errors.NONE.code())) {
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }

    private static Struct resultData(IncrementalAlterConfigsResponseData alterConfigsResponseData, KafkaRequestEvent requestEvent) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)IncrementalAlterConfigsResponseDataJsonConverter.write((IncrementalAlterConfigsResponseData)alterConfigsResponseData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("throttleTimeMs");
        for (JsonNode response : jsonNode.get("responses")) {
            ((ObjectNode)response).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)response.get("resourceType").shortValue())).name()));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

