/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestDataJsonConverter;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTopicsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(CreateTopicsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        CreateTopicsRequestData createTopicsRequestData = CreateTopicsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        CreateTopicsResponseData createTopicsResponseData = CreateTopicsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean validateOnly = createTopicsRequestData.validateOnly();
        for (CreateTopicsRequestData.CreatableTopic creatableTopic : createTopicsRequestData.topics()) {
            String topicName = creatableTopic.name();
            CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = createTopicsResponseData.topics().find(topicName);
            Struct requestData = CreateTopicsRequestAuditExtractor.requestData(creatableTopic, requestEvent, validateOnly);
            if (topicName == null || topicName.isEmpty()) {
                topicName = "TOPIC_MISSING_IN_REQUEST";
                creatableTopic.setName("TOPIC_MISSING_IN_REQUEST");
                creatableTopicResult.setName("TOPIC_MISSING_IN_REQUEST");
            }
            boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(creatableTopicResult.errorCode());
            Result.Status status = CreateTopicsRequestAuditExtractor.status(creatableTopicResult);
            Struct resultData = CreateTopicsRequestAuditExtractor.resultData(creatableTopicResult);
            List<TypedCloudResourceRef> typedCloudResourceRefList = CreateTopicsRequestAuditExtractor.typedCloudResourceRefList(requestEvent, topicName);
            ResourcePattern resourcePattern = new ResourcePattern("Topic", topicName, PatternType.LITERAL);
            String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
            AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
            extractedAuditLogs.add(auditLog);
        }
        return extractedAuditLogs;
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.TOPIC).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(CreateTopicsRequestData.CreatableTopic creatableTopic, KafkaRequestEvent requestEvent, boolean validateOnly) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)CreateTopicsRequestDataJsonConverter.CreatableTopicJsonConverter.write((CreateTopicsRequestData.CreatableTopic)creatableTopic, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)validateOnly));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(CreateTopicsResponseData.CreatableTopicResult creatableTopicResult) {
        if (creatableTopicResult.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(CreateTopicsResponseData.CreatableTopicResult creatableTopicResult) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(creatableTopicResult.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(creatableTopicResult.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)creatableTopicResult.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

