/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter;

import com.google.common.util.concurrent.Runnables;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.kafka.KafkaMessageFactory;
import io.confluent.security.audit.telemetry.exporter.NonBlockingKafkaExporterConfig;
import io.confluent.security.audit.telemetry.exporter.TopicManager;
import io.confluent.security.audit.telemetry.exporter.TopicSpec;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventLoggerConfig;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.exporter.Exporter;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.server.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingKafkaExporter
implements Exporter<Event> {
    private static final Logger log = LoggerFactory.getLogger(NonBlockingKafkaExporter.class);
    private static final long TOPIC_READY_TIMEOUT_MS = 15000L;
    private static final long TOPIC_PARTITION_TIMEOUT_MS = 1000L;
    private KafkaProducer<String, byte[]> producer;
    private volatile boolean isClosing = false;
    private final RateLimiter logRateLimiter = new RateLimiter.Builder().setMaxActionsPerWindow(50).setWindowLength(1000).build();
    private boolean createTopic;
    private Properties producerProperties;
    private String defaultRoute;
    private TopicManager topicManager;
    private Instant metadataRefreshed;
    private ScheduledThreadPoolExecutor metadataRefresh;
    private NonBlockingKafkaExporterConfig config;
    private Encoding encoding = Encoding.BINARY;
    private final EventFormat structuredEventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    public void configure(Map<String, ?> configs) {
        String encodingConfig;
        this.config = new NonBlockingKafkaExporterConfig(configs);
        this.createTopic = this.config.getBoolean("event.logger.exporter.kafka.topic.create");
        this.defaultRoute = "_confluent-events";
        this.producerProperties = this.config.producerProperties();
        this.producer = new KafkaProducer(this.producerProperties);
        switch (encodingConfig = new EventLoggerConfig(configs).getString("event.logger.cloudevent.codec")) {
            case "structured": {
                this.encoding = Encoding.STRUCTURED;
                break;
            }
            case "binary": {
                this.encoding = Encoding.BINARY;
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding " + encodingConfig);
            }
        }
        this.topicManager = TopicManager.newBuilder().setAdminClientProperties(this.config.clientProperties(AdminClientConfig.configNames())).setDefaultTopicConfig(this.config.defaultTopicConfig()).setDefaultTopicPartitions(this.config.getInt("event.logger.exporter.kafka.topic.partitions")).setDefaultTopicReplicas(this.config.getInt("event.logger.exporter.kafka.topic.replicas")).setTimeOutMs(this.config.getInt("event.logger.exporter.kafka.request.timeout.ms")).setTopics(this.config.getTopicSpecs()).build();
        this.metadataRefreshed = Instant.MIN;
        if (!this.config.getBoolean("event.logger.exporter.kafka.blocking").booleanValue()) {
            this.metadataRefresh = new ScheduledThreadPoolExecutor(1);
            ProducerConfig config = new ProducerConfig(this.producerProperties);
            long expiryMs = Math.min(config.getLong("metadata.max.age.ms"), 300000L) / 2L;
            this.metadataRefresh.scheduleAtFixedRate(this::ensureOrCheckTopicsWithMetadata, expiryMs, expiryMs, TimeUnit.MILLISECONDS);
        }
        this.ensureOrCheckTopicsWithMetadata();
    }

    public CompletableFuture<Boolean> emit(Event event) {
        return this.emit(event, Runnables.doNothing(), Runnables.doNothing());
    }

    public CompletableFuture<Boolean> emit(Event event, Runnable onSuccess, Runnable onFailure) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        try {
            String topicName;
            block10: {
                topicName = this.route(event);
                boolean topicExists = this.topicManager.topicExists(topicName);
                if (!topicExists) {
                    try {
                        Future<Boolean> f;
                        Future<Boolean> future = f = this.createTopic ? this.topicManager.ensureTopics() : this.topicManager.checkTopics();
                        if (this.config.getBoolean("event.logger.exporter.kafka.blocking").booleanValue()) {
                            boolean topicsReady = f.get(15000L, TimeUnit.MILLISECONDS);
                            if (topicsReady) {
                                log.debug("all topics created successfully");
                            }
                            break block10;
                        }
                        throw new RuntimeException("Topic " + topicName + " not found on cluster [" + this.config.getString("event.logger.exporter.kafka.bootstrap.servers") + "]");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("error while creating topics", e);
                    }
                }
            }
            if (!Thread.currentThread().isInterrupted() && !this.isClosing) {
                log.trace("Generated event log message : {}", (Object)event);
                this.producer.send(this.createProducerRecord(event, topicName), (metadata, exception) -> {
                    if (exception != null) {
                        onFailure.run();
                        exception.printStackTrace();
                        this.logRateLimiter.maybeLog(suffix -> log.error("Failed to produce event log message: {}{}", (Object)EventUtils.toJson((Event)event), suffix));
                        completableFuture.completeExceptionally(exception);
                    } else {
                        onSuccess.run();
                        log.debug("Produced event log message of size {} with offset {} to topic partition {}-{}", new Object[]{metadata.serializedValueSize(), metadata.offset(), metadata.topic(), metadata.partition()});
                        completableFuture.complete(true);
                    }
                });
            } else {
                onFailure.run();
                this.logRateLimiter.maybeLog(suffix -> log.warn("Failed to produce event log message because audit logger is closing. Message: {}{}", (Object)EventUtils.toJson((Event)event), suffix));
                completableFuture.complete(false);
            }
        }
        catch (InterruptException e) {
            completableFuture.completeExceptionally(e);
        }
        catch (Throwable t) {
            onFailure.run();
            this.logRateLimiter.maybeLog(suffix -> log.warn("Failed to produce event log message {}.{}", new Object[]{EventUtils.toJson((Event)event), suffix, t}));
            completableFuture.completeExceptionally(t);
        }
        return completableFuture;
    }

    private ProducerRecord<String, byte[]> createProducerRecord(Event event, String topic) {
        CloudEvent data = EventUtils.toCloudEvent((Event)event);
        MessageWriter messageWriter = KafkaMessageFactory.createWriter((String)topic, null);
        switch (this.encoding) {
            case STRUCTURED: {
                return (ProducerRecord)messageWriter.writeStructured(data, this.structuredEventFormat);
            }
            case BINARY: {
                return (ProducerRecord)messageWriter.writeBinary(data);
            }
        }
        throw new RuntimeException("Unknown encoding " + String.valueOf(this.encoding));
    }

    public boolean routeReady(Event event) {
        String route = this.route(event);
        boolean topicExists = this.topicManager.topicExists(route);
        if (!topicExists && this.topicManager.topicManaged(route)) {
            if (this.createTopic) {
                this.topicManager.ensureTopics();
            } else {
                this.topicManager.checkTopics();
            }
            return false;
        }
        if (topicExists) {
            return this.metadataReady(route);
        }
        return false;
    }

    private boolean metadataReady(String topic) {
        try {
            List partitionInfo = this.producer.partitionsFor(topic);
            if (!partitionInfo.isEmpty()) {
                log.debug("Event log topic {} is ready with {} partitions", (Object)topic, (Object)partitionInfo.size());
                return true;
            }
        }
        catch (Exception e) {
            log.trace("Exception while checking for event log partitions", (Throwable)e);
        }
        log.debug("Event log topic {} is NOT ready", (Object)topic);
        return false;
    }

    private String route(Event event) {
        if (event.extensionNames().contains("route")) {
            return event.extension("route");
        }
        return this.defaultRoute;
    }

    public void close() {
        this.isClosing = true;
        if (this.metadataRefresh != null) {
            this.metadataRefresh.shutdownNow();
        }
        if (this.producer != null) {
            this.producer.flush();
            this.producer.close(Duration.ofMillis(0L));
        }
        if (this.topicManager != null) {
            this.topicManager.close();
        }
    }

    public Set<String> reconfigurableConfigs() {
        return Set.of("event.logger.exporter.kafka.topic.config");
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        NonBlockingKafkaExporterConfig n = new NonBlockingKafkaExporterConfig(configs);
        n.getTopicSpecs();
    }

    public void reconfigure(Map<String, ?> configs) {
        NonBlockingKafkaExporterConfig n = new NonBlockingKafkaExporterConfig(configs);
        n.getTopicSpecs().values().stream().forEach(e -> this.topicManager.addTopic((TopicSpec)e));
        this.ensureOrCheckTopicsWithMetadata();
    }

    private void ensureOrCheckTopicsWithMetadata() {
        boolean allTopicsExist = false;
        try {
            Future<Boolean> f = this.createTopic ? this.topicManager.ensureTopics() : this.topicManager.checkTopics();
            allTopicsExist = f.get(15000L, TimeUnit.MILLISECONDS);
            if (allTopicsExist) {
                log.debug("all topics exist");
            }
        }
        catch (Exception e) {
            log.error("error while checking topics", (Throwable)e);
        }
        Set<String> topicsWithoutMetadata = this.topicManager.managedTopics();
        topicsWithoutMetadata.removeIf(this::metadataReady);
        long waited = 0L;
        if (this.createTopic || allTopicsExist) {
            while (!topicsWithoutMetadata.isEmpty() && waited < 15000L) {
                log.info("Event logger is waiting for metadata for topics: " + String.valueOf(topicsWithoutMetadata));
                try {
                    waited += 1000L;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                topicsWithoutMetadata.removeIf(this::metadataReady);
            }
        }
        if (topicsWithoutMetadata.isEmpty()) {
            log.debug("Event logger has metadata for all topics");
        } else {
            log.warn("Event logger is missing metadata for topics: " + String.valueOf(topicsWithoutMetadata));
        }
        this.metadataRefreshed = Instant.now();
    }

    public Instant lastMetadataRefresh() {
        return this.metadataRefreshed;
    }

    public NonBlockingKafkaExporterConfig config() {
        return this.config;
    }
}

