/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.confluent.security.audit.telemetry.exporter.TopicSpec;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class NonBlockingKafkaExporterConfig
extends AbstractConfig {
    public static final String KAFKA_EXPORTER_PREFIX = "event.logger.exporter.kafka.";
    public static final String PRODUCER_PREFIX = "producer.";
    public static final String EVENT_LOGGER_LOG_BLOCKING_CONFIG = "event.logger.exporter.kafka.blocking";
    public static final Boolean DEFAULT_EVENT_LOGGER_LOG_BLOCKING_CONFIG = true;
    public static final String EVENT_LOGGER_LOG_BLOCKING_CONFIG_DOC = "Block for topic creation in the log(...) method.";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "event.logger.exporter.kafka.bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for the KafkaExporter event logs will be published to. The event logs cluster may be different from the cluster(s) whose event logs are being collected. Several production KafkaExporter clusters can publish to a single event logs cluster, for example.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "event.logger.exporter.kafka.request.timeout.ms";
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 12000;
    public static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String TOPIC_CREATE_CONFIG = "event.logger.exporter.kafka.topic.create";
    public static final boolean DEFAULT_TOPIC_CREATE_CONFIG = true;
    public static final String TOPIC_CREATE_DOC = "Create the event log topic if it does not exist.";
    public static final String TOPIC_PARTITIONS_CONFIG = "event.logger.exporter.kafka.topic.partitions";
    public static final int DEFAULT_TOPIC_PARTITIONS_CONFIG = 12;
    public static final String TOPIC_PARTITIONS_DOC = "Number of partitions in the event log topic.";
    public static final String TOPIC_REPLICAS_CONFIG = "event.logger.exporter.kafka.topic.replicas";
    public static final int DEFAULT_TOPIC_REPLICAS_CONFIG = 3;
    public static final String TOPIC_REPLICAS_DOC = "Number of replicas in the event log topic. It must not be higher than the number of brokers in the KafkaExporter cluster.";
    public static final String TOPIC_RETENTION_MS_CONFIG = "event.logger.exporter.kafka.topic.retention.ms";
    public static final long DEFAULT_TOPIC_RETENTION_MS_CONFIG = TimeUnit.DAYS.toMillis(30L);
    public static final String TOPIC_RETENTION_MS_DOC = "Retention time for the event log topic.";
    public static final String TOPIC_RETENTION_BYTES_CONFIG = "event.logger.exporter.kafka.topic.retention.bytes";
    public static final long DEFAULT_TOPIC_RETENTION_BYTES_CONFIG = -1L;
    public static final String TOPIC_RETENTION_BYTES_DOC = "Retention bytes for the event log topic.";
    public static final String TOPIC_ROLL_MS_CONFIG = "event.logger.exporter.kafka.topic.roll.ms";
    public static final long DEFAULT_TOPIC_ROLL_MS_CONFIG = TimeUnit.HOURS.toMillis(4L);
    public static final String TOPIC_ROLL_MS_DOC = "Log rolling time for the event log topic.";
    public static final String DEFAULT_TOPIC = "_confluent-events";
    public static final String TOPIC_CONFIG = "event.logger.exporter.kafka.topic.config";
    public static final String DEFAULT_TOPIC_CONFIG = "{\"topics\":[{\"name\":\"_confluent-events\"}]}";
    public static final String TOPIC_CONFIG_DOC = "JSON configuration for managing topics for the Kafka exporter.";
    private static final String DEFAULT_PRODUCER_ACKS_CONFIG = "all";
    private static final String DEFAULT_PRODUCER_COMPRESSION_TYPE_CONFIG = "lz4";
    private static final String DEFAULT_PRODUCER_KEY_SERIALIZER_CLASS_CONFIG = ByteArraySerializer.class.getName();
    private static final String DEFAULT_PRODUCER_VALUE_SERIALIZER_CLASS_CONFIG = ByteArraySerializer.class.getName();
    private static final String DEFAULT_PRODUCER_LINGER_MS_CONFIG = "500";
    private static final int DEFAULT_PRODUCER_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = 1;
    private static final long DEFAULT_PRODUCER_RETRY_BACKOFF_MS_CONFIG = 500L;
    private static final ConfigDef CONFIG = new ConfigDef().define("event.logger.exporter.kafka.blocking", ConfigDef.Type.BOOLEAN, (Object)DEFAULT_EVENT_LOGGER_LOG_BLOCKING_CONFIG, ConfigDef.Importance.HIGH, "Block for topic creation in the log(...) method.").define("event.logger.exporter.kafka.bootstrap.servers", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "Bootstrap servers for the KafkaExporter event logs will be published to. The event logs cluster may be different from the cluster(s) whose event logs are being collected. Several production KafkaExporter clusters can publish to a single event logs cluster, for example.").define("event.logger.exporter.kafka.request.timeout.ms", ConfigDef.Type.INT, (Object)12000, ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("event.logger.exporter.kafka.topic.create", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Create the event log topic if it does not exist.").define("event.logger.exporter.kafka.topic.partitions", ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, "Number of partitions in the event log topic.").define("event.logger.exporter.kafka.topic.replicas", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, "Number of replicas in the event log topic. It must not be higher than the number of brokers in the KafkaExporter cluster.").define("event.logger.exporter.kafka.topic.retention.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Importance.LOW, "Retention time for the event log topic.").define("event.logger.exporter.kafka.topic.retention.bytes", ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, "Retention bytes for the event log topic.").define("event.logger.exporter.kafka.topic.config", ConfigDef.Type.STRING, (Object)"{\"topics\":[{\"name\":\"_confluent-events\"}]}", ConfigDef.Importance.LOW, "JSON configuration for managing topics for the Kafka exporter.").define("event.logger.exporter.kafka.topic.roll.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_ROLL_MS_CONFIG, ConfigDef.Importance.LOW, "Log rolling time for the event log topic.");
    private static final String DEFAULT_MIN_ISR = "1";

    public NonBlockingKafkaExporterConfig(Map<String, ?> configs) {
        super(CONFIG, configs);
    }

    private Map<String, Object> producerConfigDefaults() {
        ImmutableMap defaults = ImmutableMap.builder().put((Object)"acks", (Object)DEFAULT_PRODUCER_ACKS_CONFIG).put((Object)"compression.type", (Object)DEFAULT_PRODUCER_COMPRESSION_TYPE_CONFIG).put((Object)"key.serializer", (Object)DEFAULT_PRODUCER_KEY_SERIALIZER_CLASS_CONFIG).put((Object)"value.serializer", (Object)DEFAULT_PRODUCER_VALUE_SERIALIZER_CLASS_CONFIG).put((Object)"linger.ms", (Object)DEFAULT_PRODUCER_LINGER_MS_CONFIG).put((Object)"retry.backoff.ms", (Object)500L).put((Object)"max.in.flight.requests.per.connection", (Object)1).put((Object)"enable.idempotence", (Object)"false").put((Object)"client.id", (Object)"confluent-event-logger").build();
        return defaults;
    }

    public Properties producerProperties() {
        Properties props = new Properties();
        props.putAll(this.producerConfigDefaults());
        props.putAll((Map<?, ?>)this.clientProperties(ProducerConfig.configNames(), PRODUCER_PREFIX));
        return props;
    }

    public Properties clientProperties(Set<String> allowedKeys, String prefix) {
        Properties props = new Properties();
        for (Map.Entry entry : super.originals().entrySet()) {
            if (!((String)entry.getKey()).startsWith(KAFKA_EXPORTER_PREFIX)) continue;
            String unprefixed = ((String)entry.getKey()).substring(KAFKA_EXPORTER_PREFIX.length());
            if (allowedKeys.contains(unprefixed)) {
                props.put(unprefixed, entry.getValue());
                continue;
            }
            if (prefix == null || prefix.isEmpty() || !unprefixed.startsWith(prefix)) continue;
            props.put(unprefixed.substring(prefix.length()), entry.getValue());
        }
        if (!props.containsKey("bootstrap.servers")) {
            throw new ConfigException("Missing required property event.logger.exporter.kafka.bootstrap.servers");
        }
        return props;
    }

    public Properties clientProperties(Set<String> allowedKeys) {
        return this.clientProperties(allowedKeys, null);
    }

    public Map<String, String> defaultTopicConfig() {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        topicConfig.put("retention.ms", this.getLong(TOPIC_RETENTION_MS_CONFIG).toString());
        topicConfig.put("retention.bytes", this.getLong(TOPIC_RETENTION_BYTES_CONFIG).toString());
        topicConfig.put("segment.ms", this.getLong(TOPIC_ROLL_MS_CONFIG).toString());
        topicConfig.put("message.timestamp.type", TimestampType.CREATE_TIME.name);
        return topicConfig;
    }

    public Map<String, TopicSpec> getTopicSpecs() throws ConfigException {
        HashMap<String, TopicSpec> allTopics = new HashMap<String, TopicSpec>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            TopicSpec.Topics topics = (TopicSpec.Topics)mapper.readValue(this.getString(TOPIC_CONFIG), TopicSpec.Topics.class);
            topics.topics().stream().forEach(t -> allTopics.put(t.name(), (TopicSpec)t));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConfigException(TOPIC_CONFIG, this.get(TOPIC_CONFIG), "Invalid router config: " + e.getMessage());
        }
        return allTopics;
    }
}

