/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter.config.remote.polling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.security.audit.telemetry.exporter.config.remote.RemoteConfigurationSource;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.ICallbackResponse;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.DefaultUncaughtExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollingRemoteConfigurationSource<T>
implements RemoteConfigurationSource<T>,
ICallbackResponse {
    private static final Logger log = LoggerFactory.getLogger(PollingRemoteConfigurationSource.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("confluent-auditlog-provider-remote-config-poller-%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(log)).build());
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final long refreshIntervalMs;
    private volatile Consumer<T> callback;
    protected final Class<T> typeParameterClass;
    @VisibleForTesting
    T currentConfig;

    public PollingRemoteConfigurationSource(long refreshIntervalMs, Consumer<T> callback, Class<T> typeParameterClass) {
        Preconditions.checkArgument((refreshIntervalMs > 0L ? 1 : 0) != 0, (Object)"refresh interval must be greater than 0");
        this.refreshIntervalMs = refreshIntervalMs;
        this.callback = callback;
        this.typeParameterClass = typeParameterClass;
    }

    @Override
    public T getConfig() {
        if (this.currentConfig == null) {
            this.requestConfig().ifPresent(response -> {
                this.currentConfig = response;
                this.onCallbackSuccess();
            });
        }
        return this.currentConfig;
    }

    @Override
    public void setConfigurationChangeCallback(Consumer<T> callback) {
        this.callback = callback;
    }

    @Override
    public void stop() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.callback = null;
    }

    @Override
    public void start() {
        if (this.executor.isShutdown() || !this.isStarted.compareAndSet(false, true)) {
            throw new IllegalStateException("PollingRemoteConfigurationSource can't be started");
        }
        this.executor.scheduleWithFixedDelay(this::refresh, 0L, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void refresh() {
        try {
            if (this.callback != null) {
                this.requestConfig().ifPresent(response -> {
                    try {
                        this.currentConfig = response;
                        this.callback.accept(this.currentConfig);
                        this.onCallbackSuccess();
                    }
                    catch (Exception e) {
                        this.onCallbackFailure(e);
                        log.error("Error while processing callback", (Throwable)e);
                    }
                });
            }
        }
        catch (Throwable ex) {
            if (ex.getCause() instanceof InterruptedException) {
                return;
            }
            log.error("Unable to retrieve RemoteAuditConfiguration from Source '{}':", this.getClass(), (Object)ex);
        }
    }

    protected abstract Optional<T> requestConfig();
}

