/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.auditlog.remote.RemoteAuditConfiguration;
import io.confluent.auditlog.remote.kubernetes.ConfigSet;
import io.confluent.auditlog.remote.kubernetes.V1ConfigMap;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.ICallbackResponse;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.PollingRemoteConfigurationSource;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes.KubernetesResourceMetadata;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.security.oauthbearer.internals.secured.Retryable;
import org.apache.kafka.common.security.oauthbearer.internals.secured.UnretryableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapRemoteConfigurationSource<T>
extends PollingRemoteConfigurationSource<T>
implements Retryable<T>,
ICallbackResponse {
    private static final Logger log = LoggerFactory.getLogger(KubernetesConfigMapRemoteConfigurationSource.class);
    private static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    private static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    private static final String SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String CERTIFICATE_AUTHORITY = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String AUDIT_VERSION = RemoteAuditConfiguration.getSchemaVersion();
    public static final int DEFAULT_RESOURCE_WATCHER_RETRY_COUNT = 4;
    public static final int HTTP_CONNECTION_TIMEOUT_MS = 60000;
    public static final int HTTP_READ_TIMEOUT_MS = 60000;
    public static final String METRIC_NAME = "confluent-audit-remote-watcher";
    public static final String GROUP_NAME = "confluent-audit-metrics";
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, true);
    private final KubernetesResourceMetadata resourceMetadata;
    private Metrics metrics;
    private final Map<String, Sensor> watcherSensors;
    private final List<URL> endpoints;
    private final SSLSocketFactory sslSocketFactory;
    private String serviceAccountToken;

    public KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, Optional<String> physicalClusterId, Consumer<T> callback, Class<T> typeParameterClass) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        super(config.getRefreshIntervalMs(), callback, typeParameterClass);
        ArrayList<URL> endpoints = new ArrayList<URL>();
        this.resourceMetadata = new KubernetesResourceMetadata();
        this.watcherSensors = new ConcurrentHashMap<String, Sensor>();
        if (physicalClusterId.isPresent()) {
            endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.createEndpointFromEnv(config, physicalClusterId.get())));
        }
        endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.createDefaultEndpointFromEnv(config)));
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
    }

    @VisibleForTesting
    KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, List<URL> endpoints, Consumer<T> callback, Class<T> typeParameterClass) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        super(config.getRefreshIntervalMs(), callback, typeParameterClass);
        this.resourceMetadata = new KubernetesResourceMetadata();
        this.watcherSensors = new ConcurrentHashMap<String, Sensor>();
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
    }

    @VisibleForTesting
    static SSLSocketFactory buildSSLSocketFactory() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        try (BufferedInputStream caInput = new BufferedInputStream(Files.newInputStream(Paths.get(CERTIFICATE_AUTHORITY, new String[0]), new OpenOption[0]));){
            CertificateFactory ca = CertificateFactory.getInstance("X.509");
            int certificateNumber = 0;
            while (((InputStream)caInput).available() > 0) {
                keyStore.setCertificateEntry("ca" + certificateNumber, ca.generateCertificate(caInput));
                ++certificateNumber;
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<T> requestConfig() {
        Iterator<URL> iterator = this.endpoints.iterator();
        block17: while (iterator.hasNext()) {
            URL endpoint = iterator.next();
            try {
                InputStream is;
                HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(60000);
                connection.setReadTimeout(60000);
                connection.setRequestProperty("Authorization", "Bearer " + this.serviceAccountToken);
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
                int responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 404: {
                        log.warn("Unable to find the configmap resource at the endpoint {}. Will retry in the next attempt", (Object)endpoint);
                        if (this.metrics == null) continue block17;
                        this.recordWatcherMetric("NOT_FOUND", endpoint.getPath(), responseCode);
                        continue block17;
                    }
                    case 200: {
                        is = connection.getInputStream();
                        try {
                            Optional<T> response = this.validateConfigResponse((V1ConfigMap)this.mapper.readValue(is, V1ConfigMap.class));
                            if (this.metrics != null) {
                                this.recordWatcherMetric("SUCCESS", endpoint.getPath(), responseCode);
                            }
                            Optional<T> optional = response;
                            return optional;
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    case 401: {
                        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
                        log.warn("Auth denied for ConfigMap. Refreshing service account token.");
                        if (this.metrics == null) return Optional.empty();
                        this.recordWatcherMetric("UNAUTHORIZED", endpoint.getPath(), responseCode);
                        return Optional.empty();
                    }
                }
                is = connection.getErrorStream();
                try {
                    log.error("Error querying for ConfigMap. Status code: {} with body: {}", (Object)responseCode, (Object)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                    if (this.metrics == null) continue;
                    this.recordWatcherMetric("UNKNOWN_ERROR", endpoint.getPath(), responseCode);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Error configuring connection to Kube API Server: " + String.valueOf(e));
                if (this.metrics == null) continue;
                this.recordWatcherMetric("INTERNAL_SERVER_ERROR", endpoint.getPath(), 500);
            }
        }
        return Optional.empty();
    }

    public T call() throws ExecutionException, UnretryableException {
        Object currentConfig = this.getConfig();
        if (Objects.nonNull(currentConfig)) {
            return currentConfig;
        }
        throw new ExecutionException(new IllegalStateException("No config found"));
    }

    private Optional<T> validateConfigResponse(V1ConfigMap configMap) {
        if (this.isConfigMapChanged(configMap)) {
            try {
                Optional config = ConfigSet.parseConfigYaml((String)((String)Objects.requireNonNull(configMap.getData()).get("configs"))).getCompatibleConfigVersion(AUDIT_VERSION, this.typeParameterClass);
                this.resourceMetadata.setCurrentResourceVersion(configMap.getMetadata().getResourceVersion());
                log.info(String.format("Propagating configmap: %s of version: %s. Current Latest Version: %s, [RETRY COUNT]: %s", configMap.getMetadata().getName(), configMap.getMetadata().getResourceVersion(), this.resourceMetadata.getLatestResourceVersion(), this.resourceMetadata.getResourceWatcherFetchCount()));
                return config;
            }
            catch (JsonProcessingException e) {
                log.error("Can't parse configmap yaml", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private boolean isConfigMapChanged(V1ConfigMap configMap) {
        return this.isConfigMapValid(configMap) && (this.resourceMetadata.getLatestResourceVersion() == null || !Objects.equals(configMap.getMetadata().getResourceVersion(), this.resourceMetadata.getLatestResourceVersion()));
    }

    private boolean isConfigMapValid(V1ConfigMap configMap) {
        return configMap != null && configMap.getMetadata() != null && configMap.getMetadata().getResourceVersion() != null;
    }

    public void setMetrics(Metrics metrics) {
        log.info("Setting metrics for KubernetesConfigMapRemoteConfigurationSource");
        this.metrics = metrics;
    }

    public void recordWatcherMetric(String metricType, String path, int responseCode) {
        String sensorName = String.format("%s:%s:%s", path, metricType, responseCode);
        Map<String, String> tags = Map.of("path", path, "metricType", metricType, "responseCode", String.valueOf(responseCode));
        this.getOrCreateWatcherSensor(sensorName, tags).record();
    }

    public Sensor getOrCreateWatcherSensor(String sensorName, Map<String, String> tags) {
        this.watcherSensors.computeIfAbsent(sensorName, key -> {
            Sensor sensor = this.metrics.sensor(sensorName);
            sensor.add(this.metrics.metricName(METRIC_NAME, GROUP_NAME, "Kubernetes Remote Watcher count metrics", tags), (MeasurableStat)new CumulativeCount());
            return sensor;
        });
        return this.watcherSensors.get(sensorName);
    }

    public static String createEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config, String configMapName) {
        String path = "/api/v1/namespaces/" + config.getNamespace() + "/configmaps/" + configMapName;
        String kubeServiceHost = System.getenv(KUBERNETES_SERVICE_HOST_ENV_VAR);
        String endpoint = Objects.isNull(kubeServiceHost) || kubeServiceHost.isEmpty() ? "https://kubernetes.default.svc" + path : "https://" + kubeServiceHost + ":" + System.getenv(KUBERNETES_SERVICE_PORT_ENV_VAR) + path;
        log.info("Remote Configmap endpoint: {} configured with the name: {}", (Object)endpoint, (Object)configMapName);
        return endpoint;
    }

    public static String createDefaultEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config) {
        return KubernetesConfigMapRemoteConfigurationSource.createEndpointFromEnv(config, config.getConfigMapNameConfig());
    }

    @VisibleForTesting
    static String getKubeServiceAccountToken() throws IOException {
        return new String(Files.readAllBytes(Paths.get(SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
    }

    @VisibleForTesting
    public KubernetesResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    @VisibleForTesting
    void setLatestResourceVersion(String resourceVersion) {
        this.resourceMetadata.setLatestResourceVersion(resourceVersion);
    }

    @VisibleForTesting
    void setCurrentResourceVersion(String resourceVersion) {
        this.resourceMetadata.setCurrentResourceVersion(resourceVersion);
    }

    @Override
    public synchronized void onCallbackSuccess() {
        this.resourceMetadata.setLatestResourceVersion(this.resourceMetadata.getCurrentResourceVersion());
        this.resourceMetadata.setResourceWatcherFetchCount(0);
        log.info("Setting latest resource version :{}, current resource version: {}, retry count: {}", new Object[]{this.resourceMetadata.getLatestResourceVersion(), this.resourceMetadata.getCurrentResourceVersion(), this.resourceMetadata.getResourceWatcherFetchCount()});
    }

    @Override
    public synchronized void onCallbackFailure(Exception e) {
        if (this.resourceMetadata.getResourceWatcherFetchCount() == 4) {
            log.info("[RETRY EXHAUSTED] Setting latest resource version :{}, current resource version: {}, retry count: {}", new Object[]{this.resourceMetadata.getLatestResourceVersion(), this.resourceMetadata.getCurrentResourceVersion(), this.resourceMetadata.getResourceWatcherFetchCount()});
            this.resourceMetadata.setLatestResourceVersion(this.resourceMetadata.getCurrentResourceVersion());
            this.resourceMetadata.setResourceWatcherFetchCount(0);
        } else {
            this.resourceMetadata.incrementResourceWatcherFetchCount();
        }
    }
}

