/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCacheManagerConfig
extends SchemaRegistryConfig {
    private static final Logger log = LoggerFactory.getLogger(SchemaCacheManagerConfig.class);
    public static final String SCHEMA_CACHEMANAGER_EXPIRY_INTERVAL_SECONDS_CONFIG = "schema.cachemanager.expiry.interval.seconds";
    public static final String SCHEMA_CACHEMANAGER_CACHE_THRESHOLD_LIMIT_MINS_CONFIG = "schema.cachemanager.cache.threshold.limit.mins";
    public static final String SCHEMA_CACHEMANAGER_BULK_CONTEXT_API_LIMIT_CONFIG = "schema.cachemanager.bulk.context.api.limit";
    protected static final int SCHEMA_CACHEMANAGER_EXPIRY_INTERVAL_SECONDS_DEFAULT = 3600;
    protected static final int SCHEMA_CACHEMANAGER_CACHE_THRESHOLD_LIMIT_MINS_DEFAULT = 10;
    protected static final int SCHEMA_CACHEMANAGER_BULK_CONTEXT_API_LIMIT_DEFAULT = 100;
    protected static final String SCHEMA_CACHEMANAGER_EXPIRY_INTERVAL_SECONDS_DOC = "The interval in seconds for cache expiry cleanup in the schema cache manager.";
    protected static final String SCHEMA_CACHEMANAGER_CACHE_THRESHOLD_LIMIT_MINS_DOC = "The threshold limit in minutes for cache entries to keep during expiry cleanup. Entries older than this limit from the latest timestamp will be removed.";
    protected static final String SCHEMA_CACHEMANAGER_BULK_CONTEXT_API_LIMIT_DOC = "The maximum number of items that can be returned by the bulk context get API. This limits the response size to prevent memory issues and improve performance.";
    private static final ConfigDef serverConfig = SchemaCacheManagerConfig.baseSchemaRegistryConfigDef().define("schema.cachemanager.expiry.interval.seconds", ConfigDef.Type.INT, (Object)3600, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The interval in seconds for cache expiry cleanup in the schema cache manager.").define("schema.cachemanager.cache.threshold.limit.mins", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The threshold limit in minutes for cache entries to keep during expiry cleanup. Entries older than this limit from the latest timestamp will be removed.").define("schema.cachemanager.bulk.context.api.limit", ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The maximum number of items that can be returned by the bulk context get API. This limits the response size to prevent memory issues and improve performance.");

    public SchemaCacheManagerConfig(Properties props) throws RestConfigException {
        super(serverConfig, props);
    }

    public int schemaCacheManagerExpiryIntervalSeconds() {
        return this.getInt(SCHEMA_CACHEMANAGER_EXPIRY_INTERVAL_SECONDS_CONFIG);
    }

    public int schemaCacheManagerCacheThresholdLimitMins() {
        return this.getInt(SCHEMA_CACHEMANAGER_CACHE_THRESHOLD_LIMIT_MINS_CONFIG);
    }

    public int schemaCacheManagerBulkContextApiLimit() {
        return this.getInt(SCHEMA_CACHEMANAGER_BULK_CONTEXT_API_LIMIT_CONFIG);
    }
}

