/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager;

import com.google.inject.Inject;
import io.confluent.dekregistry.storage.DekCacheUpdateHandler;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.schema.manager.SchemaCacheManager;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCacheManagerDekUpdateHandler
implements DekCacheUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(SchemaCacheManagerDekUpdateHandler.class);
    public static final String KEY = "importDekHandler";
    public static final String DEK_REGISTRY_KEY = "dekRegistry";
    private DekRegistry dekRegistry;
    private SchemaCacheManager cacheManager;

    @Inject
    public SchemaCacheManagerDekUpdateHandler() {
    }

    public void configure(Map<String, ?> configs) {
        this.dekRegistry = (DekRegistry)configs.get(DEK_REGISTRY_KEY);
        this.dekRegistry.getSchemaRegistry().properties().put(KEY, this);
        this.dekRegistry.getSchemaRegistry().properties().put(DEK_REGISTRY_KEY, this.dekRegistry);
        this.cacheManager = new SchemaCacheManager((SchemaRegistry)this.dekRegistry.getSchemaRegistry());
    }

    public void cacheInitialized(int count, Map<TopicPartition, Long> checkpoints) {
    }

    public void startBatch(int count) {
    }

    public void handleUpdate(EncryptionKeyId key, EncryptionKey value, EncryptionKey oldValue, TopicPartition tp, long offset, long timestamp) {
        this.cacheManager.updateKeysCache(key, value, timestamp);
    }

    public void setCacheManager(SchemaCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void endBatch(int count) {
    }

    public void close() throws IOException {
    }
}

