/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager;

import com.google.inject.Module;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.spi.InjectorCreator;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.schema.manager.SchemaCacheManager;
import io.confluent.schema.manager.SchemaCacheManagerDekUpdateHandler;
import io.confluent.schema.manager.SchemaCacheManagerModule;
import io.confluent.schema.manager.SchemaCacheManagerUpdateHandler;
import io.confluent.schema.manager.web.rest.resources.BulkContextResource;
import jakarta.ws.rs.core.Configurable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCacheManagerResourceExtension
implements SchemaRegistryResourceExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaCacheManagerResourceExtension.class);
    private LifecycleInjector injector;

    protected LifecycleInjector createInjector(SchemaRegistry schemaRegistry) {
        return (LifecycleInjector)InjectorBuilder.fromModules((Module[])new Module[]{new SchemaCacheManagerModule(schemaRegistry)}).createInjector((InjectorCreator)new LifecycleInjectorCreator());
    }

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        LOG.debug("registering injector");
        this.injector = this.createInjector(schemaRegistry);
        LOG.debug("done registering injector");
        LOG.debug("registering rest classes");
        configurable.register(this.injector.getInstance(BulkContextResource.class));
        LOG.debug("done registering rest classes");
        SchemaCacheManagerUpdateHandler schemaHandler = (SchemaCacheManagerUpdateHandler)schemaRegistry.properties().get("importHandler");
        SchemaCacheManager schemaCacheManager = (SchemaCacheManager)this.injector.getInstance(SchemaCacheManager.class);
        schemaHandler.setCacheManager(schemaCacheManager);
        SchemaCacheManagerDekUpdateHandler dekHandler = (SchemaCacheManagerDekUpdateHandler)schemaRegistry.properties().get("importDekHandler");
        dekHandler.setCacheManager(schemaCacheManager);
    }

    public boolean initialized() {
        return true;
    }

    public void close() throws IOException {
        if (this.injector != null) {
            this.injector.close();
            this.injector = null;
        }
    }
}

