/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager;

import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.schema.manager.SchemaCacheManager;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCacheManagerUpdateHandler
implements SchemaUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(SchemaCacheManagerUpdateHandler.class);
    public static final String KEY = "importHandler";
    private KafkaSchemaRegistry schemaRegistry;
    private SchemaCacheManager cacheManager;

    public void configure(Map<String, ?> configs) {
        this.schemaRegistry = (KafkaSchemaRegistry)configs.get("schemaRegistry");
        this.schemaRegistry.properties().put(KEY, this);
        this.cacheManager = new SchemaCacheManager((SchemaRegistry)this.schemaRegistry);
    }

    public void cacheInitialized(Map<TopicPartition, Long> checkpoints) {
    }

    public void startBatch(int count) {
    }

    public void setCacheManager(SchemaCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        this.cacheManager.updateCache(key, value, timestamp);
    }

    public void endBatch(int count) {
    }

    public void close() throws IOException {
    }
}

