/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager.web.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.schema.manager.web.rest.entities.SchemaRegistryEvent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Kek")
public class Kek
extends SchemaRegistryEvent {
    private final String name;
    private final String kmsType;
    private final String kmsKeyId;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> kmsProps;
    private final String doc;
    private final boolean shared;
    private final Boolean deleted;

    @JsonCreator
    public Kek(@JsonProperty(value="name") String name, @JsonProperty(value="kmsType") String kmsType, @JsonProperty(value="kmsKeyId") String kmsKeyId, @JsonProperty(value="kmsProps") Map<String, String> kmsProps, @JsonProperty(value="doc") String doc, @JsonProperty(value="shared") boolean shared, @JsonProperty(value="deleted") Boolean deleted) {
        this.name = name;
        this.kmsType = kmsType;
        this.kmsKeyId = kmsKeyId;
        TreeMap<String, String> sortedKmsProps = kmsProps != null ? new TreeMap<String, String>(kmsProps) : Collections.emptySortedMap();
        this.kmsProps = Collections.unmodifiableSortedMap(sortedKmsProps);
        this.doc = doc;
        this.shared = shared;
        this.deleted = deleted;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="kmsType")
    public String getKmsType() {
        return this.kmsType;
    }

    @JsonProperty(value="kmsKeyId")
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    @JsonProperty(value="kmsProps")
    public SortedMap<String, String> getKmsProps() {
        return this.kmsProps;
    }

    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @JsonProperty(value="shared")
    public boolean isShared() {
        return this.shared;
    }

    @Override
    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return Boolean.TRUE.equals(this.deleted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Kek kek = (Kek)o;
        return this.shared == kek.shared && Objects.equals(this.name, kek.name) && Objects.equals(this.kmsType, kek.kmsType) && Objects.equals(this.kmsKeyId, kek.kmsKeyId) && Objects.equals(this.kmsProps, kek.kmsProps) && Objects.equals(this.doc, kek.doc);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public io.confluent.dekregistry.client.rest.entities.Kek toKekEntity() {
        return new io.confluent.dekregistry.client.rest.entities.Kek(this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared, this.timestamp, this.deleted != false ? Boolean.valueOf(true) : null);
    }
}

