/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager.web.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import io.confluent.schema.manager.web.rest.entities.SchemaRegistryEvent;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema
extends SchemaRegistryEvent {
    private String subject;
    private Integer version;
    private Integer id;
    private String md5;
    private String schema;
    private String schemaType = "AVRO";
    private List<SchemaReference> references = Collections.emptyList();
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private boolean deleted;

    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schema = schema;
        this.deleted = deleted;
    }

    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.schema = schema;
        this.deleted = deleted;
    }

    @JsonCreator
    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="md5") String md5, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="ruleSet") RuleSet ruleSet, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.md5 = md5;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.schema = schema;
        this.deleted = deleted;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="md5")
    public String getMd5() {
        return this.md5;
    }

    @JsonProperty(value="md5")
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @JsonIgnore
    public byte[] getMd5Bytes() {
        return this.md5 != null ? Base64.getDecoder().decode(this.md5) : null;
    }

    @JsonIgnore
    public void setMd5Bytes(byte[] bytes) {
        this.md5 = bytes != null ? Base64.getEncoder().encodeToString(bytes) : null;
    }

    @JsonProperty(value="schemaType")
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType != null ? schemaType : "AVRO";
    }

    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema that = (Schema)o;
        return this.deleted == that.deleted && Objects.equals(this.subject, that.subject) && Objects.equals(this.version, that.version) && Objects.equals(this.id, that.id) && Objects.equals(this.md5, that.md5) && Objects.equals(this.schema, that.schema) && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.id, this.md5, this.schema, this.schemaType, this.references, this.metadata, this.ruleSet, this.deleted);
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.Schema toSchemaEntity() {
        return new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(this.getSubject(), this.getVersion(), this.getId(), null, this.getSchemaType(), this.getReferences() == null ? null : this.getReferences().stream().map(SchemaReference::toRefEntity).collect(Collectors.toList()), this.getMetadata() == null ? null : this.getMetadata().toMetadataEntity(), this.getRuleSet() == null ? null : this.getRuleSet().toRuleSetEntity(), this.getSchema(), null, this.getTimestamp(), Boolean.valueOf(this.isDeleted()));
    }
}

