/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.manager.web.rest.resources;

import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.schema.exporter.web.rest.resources.SchemaRegistryResource;
import io.confluent.schema.manager.SchemaCacheManager;
import io.confluent.schema.manager.web.rest.SchemaRegistryBulkResponse;
import io.confluent.schema.manager.web.rest.entities.Config;
import io.confluent.schema.manager.web.rest.entities.Dek;
import io.confluent.schema.manager.web.rest.entities.DeleteSubject;
import io.confluent.schema.manager.web.rest.entities.Kek;
import io.confluent.schema.manager.web.rest.entities.Schema;
import io.confluent.schema.manager.web.rest.entities.SchemaRegistryEvent;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bulk/contexts")
@Singleton
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class BulkContextResource
extends SchemaRegistryResource {
    private static final Logger log = LoggerFactory.getLogger(BulkContextResource.class);
    private final SchemaCacheManager schemaCacheManager;
    public static final long MAX_BULK_LIMIT = 100L;

    @Inject
    public BulkContextResource(SchemaRegistry schemaRegistry, SchemaCacheManager schemaCacheManager) {
        super(schemaRegistry);
        this.schemaCacheManager = schemaCacheManager;
    }

    @GET
    @Path(value="/{contextName}")
    @Operation(summary="Get a list of schemas and keys by context")
    @PerformanceMetric(value="bulk.context.get")
    @DocumentedName(value="getSchemaRegistryBulkByContext")
    public SchemaRegistryBulkResponse getBulk(@PathParam(value="contextName") String contextName, @QueryParam(value="ts") long timestamp, @QueryParam(value="limit") long limit) throws StoreException {
        limit = this.clampLimit(limit);
        List<SchemaRegistryEvent> events = this.schemaCacheManager.getKeys(contextName, timestamp, limit);
        events.addAll(this.schemaCacheManager.getSchemas(contextName, timestamp, limit));
        long maxTs = events.stream().mapToLong(SchemaRegistryEvent::getTimestamp).max().orElse(0L);
        return new SchemaRegistryBulkResponse(events, maxTs);
    }

    private List<SchemaRegistryEvent> translateToResponse(List<SchemaRegistryValue> schemas) {
        long ts = 0L;
        ArrayList<SchemaRegistryEvent> schemaEvents = new ArrayList<SchemaRegistryEvent>();
        for (SchemaRegistryValue schemaRegistryValue : schemas) {
            if (schemaRegistryValue == null) continue;
            ts = Math.max(ts, schemaRegistryValue.getTimestamp());
            if (schemaRegistryValue instanceof SchemaValue) {
                SchemaValue schemaValue = (SchemaValue)schemaRegistryValue;
                Schema schema = new Schema(schemaValue.getSubject(), schemaValue.getVersion(), schemaValue.getId(), schemaValue.getMd5(), schemaValue.getSchemaType(), schemaValue.getReferences(), schemaValue.getMetadata(), schemaValue.getRuleSet(), schemaValue.getSchema(), schemaValue.isDeleted());
                schema.setTimestamp(schemaValue.getTimestamp());
                schemaEvents.add(schema);
                continue;
            }
            if (schemaRegistryValue instanceof ConfigValue) {
                ConfigValue configValue = (ConfigValue)schemaRegistryValue;
                Config config = new Config(configValue.getSubject(), configValue.getAlias(), configValue.isNormalize(), configValue.isValidateFields(), configValue.isValidateRules(), configValue.getCompatibilityLevel(), configValue.getCompatibilityGroup(), configValue.getDefaultMetadata(), configValue.getOverrideMetadata(), configValue.getDefaultRuleSet(), configValue.getOverrideRuleSet());
                config.setTimestamp(configValue.getTimestamp());
                schemaEvents.add(config);
                continue;
            }
            if (!(schemaRegistryValue instanceof DeleteSubjectValue)) continue;
            DeleteSubjectValue deleteSubjectValue = (DeleteSubjectValue)schemaRegistryValue;
            DeleteSubject deleteSubject = new DeleteSubject(deleteSubjectValue.getSubject(), deleteSubjectValue.getVersion());
            deleteSubject.setTimestamp(deleteSubjectValue.getTimestamp());
            schemaEvents.add(deleteSubject);
        }
        return schemaEvents;
    }

    public long clampLimit(long limit) {
        long maxLimit = this.schemaCacheManager.getBulkContextApiLimit();
        if (limit <= 0L || limit > maxLimit) {
            return maxLimit;
        }
        return limit;
    }

    private List<SchemaRegistryEvent> translateKeysToResponse(List<EncryptionKey> keys) {
        long ts = 0L;
        ArrayList<SchemaRegistryEvent> schemaEvents = new ArrayList<SchemaRegistryEvent>();
        for (EncryptionKey encryptionKey : keys) {
            ts = Math.max(ts, encryptionKey.getTimestamp());
            if (encryptionKey instanceof KeyEncryptionKey) {
                KeyEncryptionKey keyEncryptionKey = (KeyEncryptionKey)encryptionKey;
                Kek kek = new Kek(keyEncryptionKey.getName(), keyEncryptionKey.getKmsType(), keyEncryptionKey.getKmsKeyId(), keyEncryptionKey.getKmsProps(), keyEncryptionKey.getDoc(), keyEncryptionKey.isShared(), keyEncryptionKey.isDeleted());
                kek.setTimestamp(keyEncryptionKey.getTimestamp());
                schemaEvents.add(kek);
                continue;
            }
            if (!(encryptionKey instanceof DataEncryptionKey)) continue;
            DataEncryptionKey dataEncryptionKey = (DataEncryptionKey)encryptionKey;
            Dek dek = new Dek(dataEncryptionKey.getKekName(), dataEncryptionKey.getSubject(), dataEncryptionKey.getVersion(), dataEncryptionKey.getAlgorithm(), dataEncryptionKey.getEncryptedKeyMaterial(), dataEncryptionKey.getKeyMaterial(), dataEncryptionKey.isDeleted());
            dek.setTimestamp(dataEncryptionKey.getTimestamp());
            schemaEvents.add(dek);
        }
        return schemaEvents;
    }
}

