/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authentication.oidc.CachedGrant;
import java.time.Instant;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TokenResponse {
    private final String accessToken;
    private final String tokenType;
    private final String refreshToken;
    private final long expiresIn;
    private final String idToken;
    private final String scope;

    @JsonCreator
    public TokenResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="expires_in") long expiresIn, @JsonProperty(value="id_token") String idToken, @JsonProperty(value="scope") String scope) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.idToken = idToken;
        this.scope = scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getScope() {
        return this.scope;
    }

    public static TokenResponse fromCachedEntry(CachedGrant entry) {
        long millisLeft = entry.getExpiresAtMs() - Instant.now().toEpochMilli();
        long expiresIn = (long)Math.floor((double)millisLeft / 1000.0);
        return new TokenResponse(entry.getAccessToken(), entry.getTokenType(), entry.getRefreshToken(), expiresIn, entry.getIdToken(), entry.getScope());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public String idToken;
        public long expiresIn;
        public String scope;
        private String accessToken;
        private String tokenType;
        private String refreshToken;

        public Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public TokenResponse build() {
            return new TokenResponse(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.idToken, this.scope);
        }
    }
}

