/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.authorizer;

import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogConfigAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(AuditLogConfigAuthorizer.class);
    public static final Operation DESCRIBE = new Operation("DescribeConfigs");
    public static final Operation ALTER = new Operation("AlterConfigs");
    public static final Set<Operation> CONFIG_OPS = Set.of(DESCRIBE, ALTER);
    private static final ResourcePattern CLUSTER_RESOURCE_PATTERN = new ResourcePattern("Cluster", "kafka-cluster", PatternType.LITERAL);
    private final Authorizer authorizer;
    private final String metadataClusterId;
    private final Supplier<Iterable<String>> managedKafkaClusterIds;

    public AuditLogConfigAuthorizer(Authorizer authorizer, String metadataClusterId, Supplier<Iterable<String>> managedKafkaClusterIds) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.metadataClusterId = Objects.requireNonNull(metadataClusterId);
        this.managedKafkaClusterIds = Objects.requireNonNull(managedKafkaClusterIds);
    }

    public void authorizeAuditLogConfigAccess(SecurityContext ctx, Operation op) {
        if (!CONFIG_OPS.contains(op)) {
            throw new IllegalArgumentException(String.format("Unsupported operation %s, supported ops are %s", op, CONFIG_OPS));
        }
        HashSet<String> clusterIds = new HashSet<String>();
        clusterIds.add(this.metadataClusterId);
        this.managedKafkaClusterIds.get().forEach(clusterIds::add);
        ArrayList<Action> actions = new ArrayList<Action>(clusterIds.size());
        for (String clusterId : clusterIds) {
            Scope scope = Scope.kafkaClusterScope((String)clusterId);
            actions.add(new Action(scope, CLUSTER_RESOURCE_PATTERN, op));
        }
        KafkaPrincipal principal = this.userPrincipal(ctx);
        List results = this.authorizer.authorize(principal, "", actions);
        int i = 0;
        HashSet<String> deniedClusters = new HashSet<String>();
        for (AuthorizeResult result : results) {
            if (result != AuthorizeResult.ALLOWED) {
                deniedClusters.add((String)((Action)actions.get(i)).scope().clusters().get("kafka-cluster"));
            }
            ++i;
        }
        if (!deniedClusters.isEmpty()) {
            StringBuilder msg = new StringBuilder().append(principal).append(" not permitted to ").append(op).append(" on one or more clusters.");
            throw new AuthorizationException(msg.toString());
        }
    }

    private KafkaPrincipal userPrincipal(SecurityContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal == null) {
            return KafkaPrincipal.ANONYMOUS;
        }
        return new KafkaPrincipal("User", principal.getName());
    }
}

