/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.credentials;

import io.confluent.auditlogapi.credentials.ExtractedCredentials;
import io.confluent.common.security.auth.JwtPrincipal;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialExtractor {
    private static final Logger log = LoggerFactory.getLogger(CredentialExtractor.class);
    private final String metadataServerUrl;

    public CredentialExtractor(String metadataServerUrl) {
        this.metadataServerUrl = Objects.requireNonNull(metadataServerUrl);
    }

    public ExtractedCredentials extractCredentials(HttpServletRequest request) {
        try {
            Principal principal;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && authHeader.toUpperCase().startsWith("BEARER ") && (principal = request.getUserPrincipal()) instanceof JwtPrincipal) {
                return new ExtractedCredentials.JwtCredentials((JwtPrincipal)principal, this.metadataServerUrl, request.getRemoteHost());
            }
            return new ExtractedCredentials.NoCredentials(request.getRemoteHost());
        }
        catch (RuntimeException e) {
            log.debug("Exception while extracting credentials: " + e.getMessage(), (Throwable)e);
            return new ExtractedCredentials.NoCredentials(request.getRemoteHost());
        }
    }
}

