/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import io.confluent.auditlogapi.entities.AutoValue_AuditLogConfigMetadata;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"resource_version", "updated_at"})
@JsonSerialize(as=AuditLogConfigMetadata.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuditLogConfigMetadata {
    @JsonProperty(value="resource_version")
    public abstract String getResourceVersion();

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    public abstract Instant getUpdatedAt();

    @Nullable
    @JsonProperty(value="modified_since")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    public abstract Instant getModifiedSince();

    @Nonnull
    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuditLogConfigMetadata.Builder();
        }

        @JsonProperty(value="resource_version")
        public abstract Builder resourceVersion(String var1);

        @Nullable
        @JsonProperty(value="updated_at")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
        public abstract Builder updatedAt(Instant var1);

        abstract Instant getUpdatedAt();

        @Nullable
        @JsonProperty(value="modified_since")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
        public abstract Builder modifiedSince(Instant var1);

        abstract Instant getModifiedSince();

        abstract AuditLogConfigMetadata autoBuild();

        public AuditLogConfigMetadata build() {
            if (this.getModifiedSince() != null) {
                this.updatedAt(null);
                this.modifiedSince(this.getModifiedSince().truncatedTo(ChronoUnit.SECONDS));
            } else if (this.getUpdatedAt() != null) {
                this.updatedAt(this.getUpdatedAt().truncatedTo(ChronoUnit.SECONDS));
            }
            return this.autoBuild();
        }
    }
}

