/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.auditlogapi.entities.AuditLogConfigMetadata;
import java.time.Instant;
import javax.annotation.Nullable;

final class AutoValue_AuditLogConfigMetadata
extends AuditLogConfigMetadata {
    private final String resourceVersion;
    private final Instant updatedAt;
    private final Instant modifiedSince;

    private AutoValue_AuditLogConfigMetadata(String resourceVersion, @Nullable Instant updatedAt, @Nullable Instant modifiedSince) {
        this.resourceVersion = resourceVersion;
        this.updatedAt = updatedAt;
        this.modifiedSince = modifiedSince;
    }

    @Override
    @JsonProperty(value="resource_version")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Nullable
    @JsonProperty(value="modified_since")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    public Instant getModifiedSince() {
        return this.modifiedSince;
    }

    public String toString() {
        return "AuditLogConfigMetadata{resourceVersion=" + this.resourceVersion + ", updatedAt=" + String.valueOf(this.updatedAt) + ", modifiedSince=" + String.valueOf(this.modifiedSince) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditLogConfigMetadata) {
            AuditLogConfigMetadata that = (AuditLogConfigMetadata)o;
            return this.resourceVersion.equals(that.getResourceVersion()) && (this.updatedAt == null ? that.getUpdatedAt() == null : this.updatedAt.equals(that.getUpdatedAt())) && (this.modifiedSince == null ? that.getModifiedSince() == null : this.modifiedSince.equals(that.getModifiedSince()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resourceVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedAt == null ? 0 : this.updatedAt.hashCode();
        h$ *= 1000003;
        return h$ ^= this.modifiedSince == null ? 0 : this.modifiedSince.hashCode();
    }

    @Override
    public AuditLogConfigMetadata.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AuditLogConfigMetadata.Builder {
        private String resourceVersion;
        private Instant updatedAt;
        private Instant modifiedSince;

        Builder() {
        }

        private Builder(AuditLogConfigMetadata source) {
            this.resourceVersion = source.getResourceVersion();
            this.updatedAt = source.getUpdatedAt();
            this.modifiedSince = source.getModifiedSince();
        }

        @Override
        public AuditLogConfigMetadata.Builder resourceVersion(String resourceVersion) {
            if (resourceVersion == null) {
                throw new NullPointerException("Null resourceVersion");
            }
            this.resourceVersion = resourceVersion;
            return this;
        }

        @Override
        public AuditLogConfigMetadata.Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @Nullable
        Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public AuditLogConfigMetadata.Builder modifiedSince(Instant modifiedSince) {
            this.modifiedSince = modifiedSince;
            return this;
        }

        @Override
        @Nullable
        Instant getModifiedSince() {
            return this.modifiedSince;
        }

        @Override
        AuditLogConfigMetadata autoBuild() {
            Object missing = "";
            if (this.resourceVersion == null) {
                missing = (String)missing + " resourceVersion";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_AuditLogConfigMetadata(this.resourceVersion, this.updatedAt, this.modifiedSince);
        }
    }
}

