/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.auditlogapi.entities.AuditLogConfigPutResponse;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import java.util.Collection;

final class AutoValue_AuditLogConfigPutResponse
extends AuditLogConfigPutResponse {
    private final AuditLogConfigSpec spec;
    private final ImmutableList<String> warnings;

    private AutoValue_AuditLogConfigPutResponse(AuditLogConfigSpec spec, ImmutableList<String> warnings) {
        this.spec = spec;
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="spec")
    public AuditLogConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<String> getWarnings() {
        return this.warnings;
    }

    public String toString() {
        return "AuditLogConfigPutResponse{spec=" + String.valueOf(this.spec) + ", warnings=" + String.valueOf(this.warnings) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditLogConfigPutResponse) {
            AuditLogConfigPutResponse that = (AuditLogConfigPutResponse)o;
            return this.spec.equals(that.getSpec()) && this.warnings.equals(that.getWarnings());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.spec.hashCode();
        h$ *= 1000003;
        return h$ ^= this.warnings.hashCode();
    }

    @Override
    public AuditLogConfigPutResponse.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AuditLogConfigPutResponse.Builder {
        private AuditLogConfigSpec spec;
        private ImmutableList.Builder<String> warningsBuilder$;
        private ImmutableList<String> warnings;

        Builder() {
        }

        private Builder(AuditLogConfigPutResponse source) {
            this.spec = source.getSpec();
            this.warnings = source.getWarnings();
        }

        @Override
        public AuditLogConfigPutResponse.Builder spec(AuditLogConfigSpec spec) {
            if (spec == null) {
                throw new NullPointerException("Null spec");
            }
            this.spec = spec;
            return this;
        }

        @Override
        public AuditLogConfigPutResponse.Builder warnings(Collection<String> warnings) {
            if (this.warningsBuilder$ != null) {
                throw new IllegalStateException("Cannot set warnings after calling warningsBuilder()");
            }
            this.warnings = ImmutableList.copyOf(warnings);
            return this;
        }

        @Override
        ImmutableList.Builder<String> warningsBuilder() {
            if (this.warningsBuilder$ == null) {
                if (this.warnings == null) {
                    this.warningsBuilder$ = ImmutableList.builder();
                } else {
                    this.warningsBuilder$ = ImmutableList.builder();
                    this.warningsBuilder$.addAll(this.warnings);
                    this.warnings = null;
                }
            }
            return this.warningsBuilder$;
        }

        @Override
        public AuditLogConfigPutResponse build() {
            if (this.warningsBuilder$ != null) {
                this.warnings = this.warningsBuilder$.build();
            } else if (this.warnings == null) {
                this.warnings = ImmutableList.of();
            }
            Object missing = "";
            if (this.spec == null) {
                missing = (String)missing + " spec";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_AuditLogConfigPutResponse(this.spec, this.warnings);
        }
    }
}

