/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import io.confluent.auditlogapi.entities.AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinationConfig;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinations;
import io.confluent.auditlogapi.entities.AuditLogConfigMetadata;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategories;
import io.confluent.auditlogapi.entities.AuditLogConfigRouteCategoryTopics;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversions {
    private static final Logger log = LoggerFactory.getLogger(Conversions.class);
    private static final ObjectMapper JACKSON = new ObjectMapper();

    public static String toJson(AuditLogRouterJsonConfig config) throws JsonProcessingException {
        return JACKSON.writeValueAsString((Object)config);
    }

    public static AuditLogConfigSpec convert(AuditLogRouterJsonConfig config) {
        return AuditLogConfigSpec.builder().destinations(Conversions.convertDestinations(config.destinations)).defaultTopics(Conversions.convertDefaultTopics(config.defaultTopics)).excludedPrincipals(config.excludedPrincipals).routes(Conversions.convertRoutes(config.routes)).metadata(Conversions.convertMetadata(config.metadata)).build().withCalculatedMetadataResourceVersion();
    }

    public static AuditLogRouterJsonConfig convert(AuditLogConfigSpec spec) {
        AuditLogRouterJsonConfig result = new AuditLogRouterJsonConfig();
        result.destinations = Conversions.convertDestinations(spec.getDestinations());
        result.defaultTopics = Conversions.convertDefaultTopics(spec.getDefaultTopics());
        result.excludedPrincipals = ImmutableList.copyOf(spec.getExcludedPrincipals());
        result.routes = Conversions.convertRoutes(spec.getRoutes());
        result.metadata = Conversions.convertMetadata(spec.getMetadata());
        return result;
    }

    private static AuditLogConfigMetadata convertMetadata(AuditLogRouterJsonConfig.Metadata metadata) {
        Instant updatedAt = metadata != null && metadata.updatedAt != null && !metadata.updatedAt.isEmpty() ? Instant.from(DateTimeFormatter.ISO_INSTANT.parse(metadata.updatedAt)) : Instant.now();
        return AuditLogConfigMetadata.builder().updatedAt(updatedAt).resourceVersion("will be calculated").build();
    }

    private static AuditLogRouterJsonConfig.Metadata convertMetadata(AuditLogConfigMetadata metadata) {
        Instant updatedAt = metadata.getUpdatedAt();
        if (updatedAt == null) {
            updatedAt = metadata.getModifiedSince();
        }
        if (updatedAt == null) {
            updatedAt = Instant.now();
        }
        return new AuditLogRouterJsonConfig.Metadata(metadata.getResourceVersion(), DateTimeFormatter.ISO_INSTANT.format(updatedAt.truncatedTo(ChronoUnit.SECONDS)));
    }

    private static Map<String, AuditLogConfigRouteCategories> convertRoutes(Map<String, Map<String, Map<String, String>>> routes) {
        ImmutableMap.Builder crns = ImmutableMap.builder();
        if (routes != null) {
            routes.forEach((crn, categoriesResultsTopics) -> {
                AuditLogConfigRouteCategories.Builder categories = AuditLogConfigRouteCategories.builder();
                categoriesResultsTopics.forEach((category, resultsTopics) -> categories.put((String)category, AuditLogConfigRouteCategoryTopics.builder().allowed((String)resultsTopics.get("allowed")).denied((String)resultsTopics.get("denied")).build()));
                crns.put(crn, (Object)categories.build());
            });
        }
        return crns.build();
    }

    private static Map<String, Map<String, Map<String, String>>> convertRoutes(ImmutableSortedMap<String, AuditLogConfigRouteCategories> routes) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>();
        if (routes != null) {
            routes.forEach((crn, categories) -> result.put((String)crn, Conversions.withDefaultTopics(crn, Conversions.convertRouteRules(categories))));
        }
        return result;
    }

    public static Map<String, Map<String, String>> convertRouteRules(AuditLogConfigRouteCategories routeRules) {
        HashMap<String, Map<String, String>> categoriesMap = new HashMap<String, Map<String, String>>();
        if (routeRules != null) {
            routeRules.forEach((category, topics) -> {
                HashMap<String, String> topicsMap = new HashMap<String, String>();
                if (topics != null) {
                    if (topics.getAllowed() != null) {
                        topicsMap.put("allowed", topics.getAllowed());
                    }
                    if (topics.getDenied() != null) {
                        topicsMap.put("denied", topics.getDenied());
                    }
                }
                categoriesMap.put((String)category, (Map<String, String>)topicsMap);
            });
        }
        return categoriesMap;
    }

    private static AuditLogConfigDefaultTopics convertDefaultTopics(AuditLogRouterJsonConfig.DefaultTopics defaultTopics) {
        return AuditLogConfigDefaultTopics.builder().allowed(defaultTopics.allowed).denied(defaultTopics.denied).build();
    }

    private static AuditLogRouterJsonConfig.DefaultTopics convertDefaultTopics(AuditLogConfigDefaultTopics defaultTopics) {
        return new AuditLogRouterJsonConfig.DefaultTopics(defaultTopics.getAllowed(), defaultTopics.getDenied());
    }

    private static AuditLogConfigDestinations convertDestinations(AuditLogRouterJsonConfig.Destinations destinations) {
        return AuditLogConfigDestinations.builder().bootstrapServers((Collection<String>)Conversions.convertBootstrapServers(destinations.bootstrapServers)).topics(Conversions.toTopics(destinations.topics)).build();
    }

    private static AuditLogRouterJsonConfig.Destinations convertDestinations(AuditLogConfigDestinations destinations) {
        AuditLogRouterJsonConfig.Destinations result = new AuditLogRouterJsonConfig.Destinations(destinations.getBootstrapServers());
        destinations.getTopics().forEach((name, destination) -> result.topics.put(name, new AuditLogRouterJsonConfig.DestinationTopic(destination.getRetentionMs().longValue())));
        return result;
    }

    private static ImmutableList<String> convertBootstrapServers(List<String> bootstrapServers) {
        return bootstrapServers == null ? ImmutableList.of() : ImmutableList.copyOf(bootstrapServers);
    }

    private static Map<String, AuditLogConfigDestinationConfig> toTopics(Map<String, AuditLogRouterJsonConfig.DestinationTopic> topics) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        topics.forEach((name, topic) -> builder.put(name, (Object)AuditLogConfigDestinationConfig.builder().retentionMs(topic.retentionMs).build()));
        return builder.build();
    }

    private static boolean isDefaultEnabledCategory(String category) {
        return AuditLogRouterUtils.DEFAULT_ENABLED_CATEGORIES.contains(category);
    }

    public static Map<String, Map<String, String>> withDefaultTopics(ConfluentResourceName routeCrn, Map<String, ? extends Map<String, String>> routeRules) {
        return Conversions.withDefaultTopics(Conversions.allPossibleCategories(routeCrn), routeRules);
    }

    public static Map<String, Map<String, String>> withDefaultTopics(String routeCrn, Map<String, ? extends Map<String, String>> routeRules) {
        return Conversions.withDefaultTopics(Conversions.allPossibleCategories(routeCrn), routeRules);
    }

    private static Map<String, Map<String, String>> withDefaultTopics(Iterable<String> categories, Map<String, ? extends Map<String, String>> routeRules) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (routeRules != null) {
            routeRules.forEach((category, categoryRules) -> result.put((String)category, categoryRules == null ? new HashMap() : new HashMap(categoryRules)));
        }
        categories.forEach(category -> {
            Map categoryRules = result.computeIfAbsent((String)category, k -> new HashMap());
            if (Conversions.isDefaultEnabledCategory(category)) {
                categoryRules.putIfAbsent("allowed", null);
                categoryRules.putIfAbsent("denied", null);
            } else {
                categoryRules.putIfAbsent("allowed", "");
                categoryRules.putIfAbsent("denied", "");
            }
        });
        return result;
    }

    private static Set<String> allPossibleCategories(ConfluentResourceName routeCrn) {
        HashSet<String> categories = new HashSet<String>();
        if (!routeCrn.elements().isEmpty()) {
            switch (routeCrn.resourceType()) {
                case "delegation-token": {
                    categories.add("describe");
                    break;
                }
                case "group": {
                    categories.add("consume");
                    categories.add("describe");
                    categories.add("heartbeat");
                    categories.add("management");
                    break;
                }
                case "topic": {
                    categories.add("consume");
                    categories.add("describe");
                    categories.add("management");
                    categories.add("produce");
                    break;
                }
                case "transactional-id": {
                    categories.add("consume");
                    categories.add("describe");
                    categories.add("produce");
                    break;
                }
                case "kafka": {
                    categories.add("authentication");
                    categories.add("describe");
                    categories.add("interbroker");
                    categories.add("management");
                    categories.add("produce");
                    break;
                }
            }
        }
        categories.add("authorize");
        if (AuditLogRouterUtils.CATEGORIES.contains("other") && categories.contains("management")) {
            categories.add("other");
            categories.remove("management");
        }
        return categories;
    }

    private static Set<String> allPossibleCategories(String routeCrn) {
        try {
            ConfluentResourceName crn = ConfluentResourceName.fromString((String)routeCrn);
            return Conversions.allPossibleCategories(crn);
        }
        catch (CrnSyntaxException e) {
            return AuditLogRouterUtils.CATEGORIES;
        }
    }
}

