/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mds;

import io.confluent.mds.DynamicConfigurator;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Utils;

public class DefaultDynamicConfigurator
implements DynamicConfigurator {
    private final ConfluentAdmin adminClient;
    private final ConfigResource clusterResource = new ConfigResource(ConfigResource.Type.BROKER, "");

    public DefaultDynamicConfigurator(ConfluentAdmin adminClient) {
        this.adminClient = adminClient;
    }

    @Override
    public KafkaFuture<Config> getClusterConfig() {
        return (KafkaFuture)this.adminClient.describeConfigs(Collections.singleton(this.clusterResource)).values().get(this.clusterResource);
    }

    @Override
    public AlterConfigsResult setClusterConfig(Set<ConfigEntry> configEntries) {
        return this.adminClient.incrementalAlterConfigs(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.clusterResource, (Object)configEntries.stream().map(entry -> new AlterConfigOp(entry, AlterConfigOp.OpType.SET)).collect(Collectors.toSet()))}));
    }

    @Override
    public AlterConfigsResult deleteClusterConfig(Set<ConfigEntry> configEntries) {
        return this.adminClient.incrementalAlterConfigs(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.clusterResource, (Object)configEntries.stream().map(entry -> new AlterConfigOp(entry, AlterConfigOp.OpType.DELETE)).collect(Collectors.toSet()))}));
    }

    @Override
    public void close() {
        Utils.closeQuietly((AutoCloseable)this.adminClient, (String)"DefaultDynamicConfigurator.adminClient");
    }
}

