/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metadataapi.errormappers;

import io.confluent.metadataapi.entities.ErrorMessage;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataApiExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(MetadataApiExceptionMapper.class);
    @Context
    private UriInfo uriInfo;

    public Response toResponse(Exception exception) {
        int statusCode;
        log.debug("Uncaught exception in REST call to /{}", (Object)this.uriInfo.getPath(), (Object)exception);
        if (exception instanceof WebApplicationException) {
            Response.StatusType statusInfo = ((WebApplicationException)exception).getResponse().getStatusInfo();
            statusCode = statusInfo.getStatusCode();
        } else {
            statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        }
        return Response.status((int)statusCode).entity((Object)new ErrorMessage(statusCode, exception.getMessage())).build();
    }
}

