/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.converters;

import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.ext.ParamConverter;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class KafkaPrincipalConverter
implements ParamConverter<KafkaPrincipal> {
    private static final Set<String> ALLOWED_PRINCIPAL_TYPES = ImmutableSet.of((Object)"User", (Object)"Group");

    public KafkaPrincipal fromString(String principalStr) {
        KafkaPrincipal kafkaPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        if (!ALLOWED_PRINCIPAL_TYPES.contains(kafkaPrincipal.getPrincipalType())) {
            throw new RuntimeException(String.format("Invalid principal type: %s\nShould start with any of the following types: %s (i.e. User:bob)", principalStr, ALLOWED_PRINCIPAL_TYPES));
        }
        return kafkaPrincipal;
    }

    public String toString(KafkaPrincipal kafkaPrincipal) {
        return kafkaPrincipal.toString();
    }
}

