/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rbacapi.jackson.V1AccessPolicy;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import io.confluent.security.roledefinitions.Role;

public class V1Role {
    private final String name;
    private final V1AccessPolicy accessPolicy;

    @JsonCreator
    public V1Role(@JsonProperty(value="name") String name, @JsonProperty(value="accessPolicy") V1AccessPolicy accessPolicy) {
        this.name = name;
        this.accessPolicy = accessPolicy;
    }

    public V1Role(Role role) {
        this.name = role.displayName();
        if (role.accessPolicies().size() != 1) {
            throw new InvalidRoleDefinitionException("V1 roles must have one access policy");
        }
        this.accessPolicy = new V1AccessPolicy((AccessPolicy)role.flatAccessPolicies().iterator().next());
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty(value="accessPolicy")
    public V1AccessPolicy accessPolicy() {
        return this.accessPolicy;
    }
}

