/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.provider;

import io.confluent.http.server.KafkaHttpApplicationProvider;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.rbacapi.app.CPRbacApiAppConfig;
import io.confluent.rbacapi.app.RbacApiApplication;
import io.confluent.rest.Application;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.ConfluentAuthorizerConfig;
import io.confluent.tokenapi.jwt.JwtProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.server.http.MetadataServerConfig;

public final class RbacApplicationProvider
implements KafkaHttpApplicationProvider {
    public List<Application<?>> provideApplications(Map<String, Object> configs, KafkaHttpServerInjector kafkaHttpServerInjector) {
        if (!new MetadataServerConfig(configs).isConfluentMetadataServerEnabled()) {
            return Collections.emptyList();
        }
        Set accessRuleProviders = ConfluentAuthorizerConfig.accessRuleProviders(configs);
        if (accessRuleProviders.contains("CONFLUENT") || accessRuleProviders.contains("CC_CONTROL_PLANE_MDS_DB") || accessRuleProviders.contains("CC_DATAPLANE_PLANE_MDS")) {
            ClusterResource clusterResource = (ClusterResource)kafkaHttpServerInjector.getInstance(ClusterResource.class);
            Authorizer authorizer = (Authorizer)kafkaHttpServerInjector.getInstance(Authorizer.class);
            AuthStore authStore = (AuthStore)kafkaHttpServerInjector.getInstance(AuthStore.class);
            ConfluentAdmin adminClient = (ConfluentAdmin)kafkaHttpServerInjector.getInstance(ConfluentAdmin.class);
            AuthenticateCallbackHandler authenticateCallbackHandler = (AuthenticateCallbackHandler)kafkaHttpServerInjector.getInstance(AuthenticateCallbackHandler.class);
            return Arrays.asList(new RbacApiApplication(CPRbacApiAppConfig.scoped(configs), authorizer, authStore, new JwtProvider(), authenticateCallbackHandler, clusterResource.clusterId(), adminClient));
        }
        return Collections.emptyList();
    }
}

