/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.provider.credentials.sha;

import com.google.common.hash.HashFunction;
import io.confluent.rbacapi.provider.credentials.HashedCredentialProvider;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.BiFunction;

abstract class ShaHashedCredentialProvider
extends HashedCredentialProvider {
    private final BiFunction<String, Optional<String>, String> hashingFunction = (incomingCredentials, saltOptional) -> {
        if (saltOptional.isPresent()) {
            String firstHash = this.doHash((String)incomingCredentials);
            return this.doHash(firstHash + (String)saltOptional.get());
        }
        return this.doHash((String)incomingCredentials);
    };

    ShaHashedCredentialProvider() {
    }

    @Override
    protected BiFunction<String, Optional<String>, String> hashingFunction() {
        return this.hashingFunction;
    }

    abstract HashFunction getShaFunction();

    private String doHash(String input) {
        return this.getShaFunction().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
    }
}

