/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.security.auth.client.rest.entities.AclFilter;
import io.confluent.security.auth.client.rest.entities.CreateAclRequest;
import io.confluent.security.auth.client.rest.entities.CreateAclsRequest;
import io.confluent.security.auth.client.rest.entities.CreateAclsResult;
import io.confluent.security.auth.client.rest.entities.DeleteAclsRequest;
import io.confluent.security.auth.client.rest.entities.DeleteAclsResult;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.Scope;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePattern;

public class AclResource {
    private final AuthStore authStore;
    private final AuthCache authCache;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final long backendTimeoutNanos;

    public AclResource(AuthStore authStore, SecurityMetadataAuthorizer metadataAuthorizer, long backendTimeoutNanos) {
        this.authStore = authStore;
        this.authCache = authStore.authCache();
        this.metadataAuthorizer = metadataAuthorizer;
        this.backendTimeoutNanos = backendTimeoutNanos;
    }

    public void createAcl(SecurityContext context, CreateAclRequest createAclRequest) throws InterruptedException, ExecutionException, TimeoutException {
        this.createAcl(context, createAclRequest.scope, createAclRequest.aclBinding);
    }

    private void createAcl(SecurityContext context, Scope scope, AclBinding aclBinding) throws InterruptedException, ExecutionException, TimeoutException {
        io.confluent.security.authorizer.ResourcePattern resourcePattern = io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)aclBinding.pattern());
        this.metadataAuthorizer.authorizeAclAccess(context, scope, resourcePattern, SecurityMetadataAuthorizer.ALTER, SecurityMetadataAuthorizer.ALTER_ACCESS);
        CompletionStage cs = this.authStore.writer().createAcls(scope, aclBinding);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public CreateAclsResult createAcls(SecurityContext context, CreateAclsRequest createAclRequest) {
        HashMap<AclBinding, CreateAclsResult.CreateResult> resultMap = new HashMap<AclBinding, CreateAclsResult.CreateResult>();
        for (AclBinding aclBinding : createAclRequest.aclBindings) {
            try {
                this.createAcl(context, createAclRequest.scope, aclBinding);
                resultMap.put(aclBinding, CreateAclsResult.SUCCESS);
            }
            catch (TimeoutException e) {
                resultMap.put(aclBinding, CreateAclsResult.failure((String)"MDS Server timeout occurred"));
            }
            catch (Exception e) {
                resultMap.put(aclBinding, CreateAclsResult.failure((String)e.getMessage()));
            }
        }
        return new CreateAclsResult(resultMap);
    }

    public Collection<AclBinding> deleteAcls(SecurityContext context, AclFilter deleteAclRequest) throws InterruptedException, ExecutionException, TimeoutException {
        return this.deleteAcl(context, deleteAclRequest.scope, deleteAclRequest.aclBindingFilter);
    }

    public DeleteAclsResult deleteAcls(SecurityContext context, DeleteAclsRequest deleteAclRequest) {
        HashMap<AclBindingFilter, DeleteAclsResult.DeleteResult> resultMap = new HashMap<AclBindingFilter, DeleteAclsResult.DeleteResult>();
        for (AclBindingFilter aclBindingFilter : deleteAclRequest.aclBindingFilters) {
            try {
                Collection<AclBinding> deletedBindings = this.deleteAcl(context, deleteAclRequest.scope, aclBindingFilter);
                resultMap.put(aclBindingFilter, DeleteAclsResult.success(deletedBindings));
            }
            catch (TimeoutException e) {
                resultMap.put(aclBindingFilter, DeleteAclsResult.failure((String)"MDS Server timeout occurred"));
            }
            catch (Exception e) {
                resultMap.put(aclBindingFilter, DeleteAclsResult.failure((String)e.getMessage()));
            }
        }
        return new DeleteAclsResult(resultMap);
    }

    private Collection<AclBinding> deleteAcl(SecurityContext context, Scope scope, AclBindingFilter aclBindingFilter) throws InterruptedException, ExecutionException, TimeoutException {
        Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess = resourcePattern -> this.metadataAuthorizer.aclAccess(context, scope, resourcePattern, SecurityMetadataAuthorizer.ALTER, SecurityMetadataAuthorizer.ALTER_ACCESS);
        CompletionStage cs = this.authStore.writer().deleteAcls(scope, aclBindingFilter, resourceAccess);
        return (Collection)cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public Collection<AclBinding> describeAcls(SecurityContext context, AclFilter describeAclRequest) {
        Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess = resourcePattern -> this.metadataAuthorizer.aclAccess(context, describeAclRequest.scope, resourcePattern, SecurityMetadataAuthorizer.DESCRIBE, SecurityMetadataAuthorizer.DESCRIBE_ACCESS);
        return this.authCache.aclBindings(describeAclRequest.scope, describeAclRequest.aclBindingFilter, resourceAccess);
    }
}

