/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.utils.ClusterType;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ClusterRegistryResource {
    private final ClusterRegistryService clusterRegistryService;
    private final SecurityMetadataAuthorizer metadataAuthorizer;

    public ClusterRegistryResource(ClusterRegistryService clusterRegistryService, SecurityMetadataAuthorizer metadataAuthorizer) {
        this.metadataAuthorizer = metadataAuthorizer;
        this.clusterRegistryService = clusterRegistryService;
    }

    public List<ClusterInfo> getAllClusters(SecurityContext securityContext, ClusterType clusterType) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(securityContext);
        return this.clusterRegistryService.getClusters(callingPrincipal, clusterType);
    }

    public ClusterInfo getNamedCluster(SecurityContext securityContext, String clusterName) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(securityContext);
        return this.clusterRegistryService.getNamedCluster(callingPrincipal, clusterName);
    }

    public void updateClusters(SecurityContext securityContext, List<ClusterInfo> clusters) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(securityContext);
        this.clusterRegistryService.overwriteClusters(callingPrincipal, clusters);
    }

    public void deleteNamedCluster(SecurityContext securityContext, String clusterName) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(securityContext);
        this.clusterRegistryService.deleteNamedCluster(callingPrincipal, clusterName);
    }
}

