/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.converters.V1MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.utils.RoleAccessUtils;
import io.confluent.rbacapi.utils.RoleUtils;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.UserMetadata;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class UserGroupResource {
    private final AuthCache authCache;
    private final ClusterRegistryService clusterRegistryService;
    private final MdsScopeConverter mdsScopeConverter;
    private final ValidationUtil validationUtil;
    private final SecurityMetadataAuthorizer metadataAuthorizer;

    public UserGroupResource(AuthCache authCache, ClusterRegistryService clusterRegistryService, ValidationUtil validationUtil, SecurityMetadataAuthorizer metadataAuthorizer) {
        this.authCache = authCache;
        this.clusterRegistryService = clusterRegistryService;
        this.validationUtil = validationUtil;
        this.mdsScopeConverter = new V1MdsScopeConverter(this.clusterRegistryService, validationUtil);
        this.metadataAuthorizer = metadataAuthorizer;
    }

    public List<String> getUserGroupList(SecurityContext context, String principalType, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.checkIfRoleBindingAdminOnScope(callingPrincipal, scope);
        String fixedPrincipalType = StringUtils.isBlank((CharSequence)principalType) ? "both" : principalType;
        return this.getList(fixedPrincipalType);
    }

    private void checkIfRoleBindingAdminOnScope(KafkaPrincipal callerPrincipal, Scope scope) {
        Set roleBindings = this.authCache.rbacRoleBindings(callerPrincipal, Collections.singleton(scope));
        Set managementRoles = RoleUtils.mapRolesByName((Collection)this.authCache.rbacRoles().roles(), (Predicate)RoleAccessUtils.filterByDescribeAccess()).keySet();
        boolean hasManagementRoles = roleBindings.stream().anyMatch(roleBinding -> managementRoles.contains(roleBinding.role()));
        if (!hasManagementRoles) {
            throw new ForbiddenException();
        }
    }

    private List<String> getList(String principalType) {
        Map users = this.authCache.users();
        switch (principalType) {
            case "user": {
                return UserGroupResource.getUserListFromMap(users);
            }
            case "group": {
                return UserGroupResource.getGroupListFromMap(users);
            }
        }
        return Stream.concat(UserGroupResource.getGroupListFromMap(users).stream(), UserGroupResource.getUserListFromMap(users).stream()).collect(Collectors.toList());
    }

    private static List<String> getUserListFromMap(Map<KafkaPrincipal, UserMetadata> users) {
        return users.keySet().stream().map(kafkaPrincipal -> kafkaPrincipal.toString()).filter(user -> !user.equals("User:")).sorted().collect(Collectors.toList());
    }

    private static List<String> getGroupListFromMap(Map<KafkaPrincipal, UserMetadata> users) {
        return users.values().stream().flatMap(userMetadata -> userMetadata.groups().stream()).map(groupPrincipal -> groupPrincipal.toString()).distinct().sorted().collect(Collectors.toList());
    }
}

