/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.resources.base.ClusterRegistryResource;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.validation.v1.V1ValidClusterInfoList;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;

@Path(value="/1.0/registry")
@Produces(value={"application/json"})
public class V1ClusterRegistryResource {
    private final ClusterRegistryResource delegate;

    public V1ClusterRegistryResource(ClusterRegistryService clusterRegistryService, SecurityMetadataAuthorizer metadataAuthorizer) {
        this.delegate = new ClusterRegistryResource(clusterRegistryService, metadataAuthorizer);
    }

    @GET
    @Path(value="/clusters")
    @PerformanceMetric(value="v1.get.all.clusters")
    public List<ClusterInfo> getAllClusters(@Context SecurityContext securityContext, @QueryParam(value="clusterType") ClusterType clusterType) {
        return this.delegate.getAllClusters(securityContext, clusterType);
    }

    @GET
    @Path(value="/clusters/{clusterName}")
    @PerformanceMetric(value="v1.get.named.cluster")
    public ClusterInfo getNamedCluster(@Context SecurityContext securityContext, @PathParam(value="clusterName") String clusterName) {
        return this.delegate.getNamedCluster(securityContext, clusterName);
    }

    @POST
    @Path(value="/clusters")
    @PerformanceMetric(value="v1.update.clusters")
    public void updateClusters(@Context SecurityContext securityContext, @V1ValidClusterInfoList List<ClusterInfo> clusters) {
        this.delegate.updateClusters(securityContext, clusters);
    }

    @DELETE
    @Path(value="/clusters/{clusterName}")
    @PerformanceMetric(value="v1.delete.named.cluster")
    public void deleteNamedCluster(@Context SecurityContext securityContext, @PathParam(value="clusterName") String clusterName) {
        this.delegate.deleteNamedCluster(securityContext, clusterName);
    }
}

