/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.oidc.entities.CheckDeviceAuthRequest;
import io.confluent.oidc.entities.CheckDeviceAuthResponse;
import io.confluent.oidc.entities.ExtendAuthResponse;
import io.confluent.oidc.entities.InitDeviceAuthResponse;
import io.confluent.oidc.resources.OidcDeviceAuthResource;
import io.confluent.oidc.services.OidcTokenService;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.tokenapi.entities.RefreshTokenRequest;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/1.0/oidc/device")
@Produces(value={"application/json"})
public class V1OidcDeviceAuthResource {
    private final OidcDeviceAuthResource delegate;

    public V1OidcDeviceAuthResource(OidcTokenService oidcTokenService) {
        this.delegate = new OidcDeviceAuthResource(oidcTokenService);
    }

    @POST
    @Path(value="/authenticate")
    @PerformanceMetric(value="v1.oidc.device.authenticate")
    public InitDeviceAuthResponse createDeviceAuthInfo() {
        return this.delegate.createDeviceAuthInfo();
    }

    @POST
    @Path(value="/check-auth")
    @PerformanceMetric(value="v1.oidc.device.check-auth")
    public CheckDeviceAuthResponse checkAuth(CheckDeviceAuthRequest request) {
        return this.delegate.checkUserAuthAction(request);
    }

    @POST
    @Path(value="/extend-auth")
    @PerformanceMetric(value="v1.oidc.device.extend-auth")
    public ExtendAuthResponse extendAuth(RefreshTokenRequest refreshTokenRequest) {
        return this.delegate.extendAuth(refreshTokenRequest);
    }
}

