/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.converters.V1MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ResourcesRequest;
import io.confluent.rbacapi.resources.base.PrincipalsResource;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.utils.RoleUtils;
import io.confluent.rbacapi.utils.RoleUtilsBase;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.rbacapi.validation.common.ValidPrincipal;
import io.confluent.rbacapi.validation.common.ValidRole;
import io.confluent.rbacapi.validation.v1.V1ValidMdsScope;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.ResourcePattern;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

@Path(value="/1.0/principals")
public class V1PrincipalsResource {
    private final PrincipalsResource delegate;
    private final MdsScopeConverter mdsScopeConverter;

    public V1PrincipalsResource(AuthStore authStore, SecurityMetadataAuthorizer metadataAuthorizer, long backendTimeoutNanos, ClusterRegistryService clusterRegistryService, ObjectMapper objectMapper) {
        this.mdsScopeConverter = new V1MdsScopeConverter(clusterRegistryService, (ValidationUtil)new V1ValidationUtil());
        this.delegate = new PrincipalsResource(authStore, metadataAuthorizer, backendTimeoutNanos, (ValidationUtil)new V1ValidationUtil(), objectMapper, (RoleUtilsBase)new RoleUtils(), this.mdsScopeConverter);
    }

    @POST
    @Path(value="{principal:.*}/roles/{roleName}")
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v1.add.cluster.role.for.principal")
    public void addClusterRoleForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, @V1ValidMdsScope MdsScope mdsScope) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.addClusterRoleForPrincipal(context, principalStr, roleName, mdsScope);
    }

    @DELETE
    @Path(value="{principal:.*}/roles/{roleName}")
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v1.delete.role.for.principal")
    public void deleteRoleForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, @V1ValidMdsScope MdsScope mdsScope) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.deleteRoleForPrincipal(context, principalStr, roleName, mdsScope);
    }

    @POST
    @Path(value="{principal:.*}/roles/{roleName}/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.get.role.resources.for.principal")
    public List<ResourcePattern> getRoleResourcesForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, @V1ValidMdsScope MdsScope mdsScope) {
        return this.delegate.getRoleResourcesForPrincipal(context, principalStr, roleName, mdsScope);
    }

    @POST
    @Path(value="{principal:.*}/roles/{roleName}/bindings")
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v1.add.role.resources.for.principal")
    public void addRoleResourcesForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.addRoleResourcesForPrincipal(context, principalStr, roleName, resourcesRequest);
    }

    @DELETE
    @Path(value="{principal:.*}/roles/{roleName}/bindings")
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v1.delete.role.resources.for.principal")
    public void deleteRoleResourcesForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.deleteRoleResourcesForPrincipal(context, principalStr, roleName, resourcesRequest);
    }

    @PUT
    @Path(value="{principal:.*}/roles/{roleName}/bindings")
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v1.set.role.resources.for.principal")
    public void setRoleResourcesForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @PathParam(value="roleName") @ValidRole String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        this.delegate.setRoleResourcesForPrincipal(context, principalStr, roleName, resourcesRequest);
    }
}

