/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.jackson.V1Role;
import io.confluent.rbacapi.resources.base.RolesResource;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.Role;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;

@Path(value="/1.0/")
@Produces(value={"application/json"})
public class V1RolesResource {
    private final RolesResource delegate;

    public V1RolesResource(RbacRoles rbacRoles) {
        this.delegate = new RolesResource(rbacRoles);
    }

    @GET
    @Path(value="roles")
    @PerformanceMetric(value="v1.roles.list")
    public List<V1Role> roles() {
        return this.delegate.roles().stream().map(V1Role::new).collect(Collectors.toList());
    }

    @GET
    @Path(value="roles/{roleName}")
    @PerformanceMetric(value="v1.role.get")
    public V1Role role(@PathParam(value="roleName") String roleName) {
        Role role = this.delegate.role(roleName);
        if (role == null) {
            return null;
        }
        return new V1Role(role);
    }

    @GET
    @Path(value="roleNames")
    @PerformanceMetric(value="v1.rolenames.list")
    public List<String> roleNames() {
        return this.delegate.roleNames();
    }
}

