/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import io.confluent.rest.FileWatcher;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactoryPemHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import org.apache.kafka.common.config.types.Password;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSslFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientSslFactory.class);

    public static SslContextFactory createSslContextFactory(SslConfig sslConfig) {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        if (!sslConfig.getKeyStorePath().isEmpty()) {
            ClientSslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, true, false);
            sslContextFactory.setKeyManagerPassword(sslConfig.getKeyManagerPassword());
            if (!sslConfig.getKeyManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setKeyManagerFactoryAlgorithm(sslConfig.getKeyManagerFactoryAlgorithm());
            }
            if (sslConfig.getReloadOnKeyStoreChange()) {
                Path watchLocation = Paths.get(sslConfig.getReloadOnKeyStoreChangePath(), new String[0]);
                try {
                    FileWatcher.onFileChange((Path)watchLocation, (FileWatcher.Callback)ClientSslFactory.onFileChangeCallback(sslConfig, sslContextFactory));
                    log.info("Enabled SSL cert auto reload for: " + String.valueOf(watchLocation));
                }
                catch (IOException e) {
                    log.error("Cannot enable SSL cert auto reload", (Throwable)e);
                }
            }
        }
        if (!sslConfig.getIncludeProtocols().isEmpty()) {
            sslContextFactory.setIncludeProtocols(sslConfig.getIncludeProtocols().toArray(new String[0]));
        }
        if (!sslConfig.getIncludeCipherSuites().isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(sslConfig.getIncludeCipherSuites().toArray(new String[0]));
        }
        sslContextFactory.setEndpointIdentificationAlgorithm(sslConfig.getEndpointIdentificationAlgorithm());
        if (!sslConfig.getTrustStorePath().isEmpty()) {
            ClientSslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, false, false);
            if (!sslConfig.getTrustManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(sslConfig.getTrustManagerFactoryAlgorithm());
            }
        }
        sslContextFactory.setProtocol(sslConfig.getProtocol());
        if (!sslConfig.getProvider().isEmpty()) {
            ClientSslFactory.configureSecurityProvider(sslContextFactory, sslConfig);
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    private static void setSecurityStoreProps(SslConfig sslConfig, SslContextFactory.Client sslContextFactory, boolean isKeyStore, boolean setPathOnly) {
        boolean isPem = SslFactoryPemHelper.isPemSecurityStore((String)(isKeyStore ? sslConfig.getKeyStoreType() : sslConfig.getTrustStoreType()));
        if (isPem) {
            log.info("PEM security store detected! Converting to {} - isKeyStore {}", (Object)SslFactoryPemHelper.getKeyStoreType((String)sslConfig.getProvider()), (Object)isKeyStore);
            if (isKeyStore) {
                sslContextFactory.setKeyStore(SslFactoryPemHelper.getKeyStoreFromPem((String)sslConfig.getKeyStorePath(), (String)sslConfig.getKeyStoreType(), (Password)new Password(sslConfig.getKeyManagerPassword()), (String)sslConfig.getProvider(), (boolean)isKeyStore));
            } else {
                sslContextFactory.setTrustStore(SslFactoryPemHelper.getKeyStoreFromPem((String)sslConfig.getTrustStorePath(), (String)sslConfig.getTrustStoreType(), (Password)new Password(sslConfig.getKeyManagerPassword()), (String)sslConfig.getProvider(), (boolean)isKeyStore));
            }
        } else if (isKeyStore) {
            sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
            if (!setPathOnly) {
                sslContextFactory.setKeyStorePassword(sslConfig.getKeyStorePassword());
                sslContextFactory.setKeyStoreType(sslConfig.getKeyStoreType());
            }
        } else {
            sslContextFactory.setTrustStorePath(sslConfig.getTrustStorePath());
            if (!setPathOnly) {
                sslContextFactory.setTrustStorePassword(sslConfig.getTrustStorePassword());
                sslContextFactory.setTrustStoreType(sslConfig.getTrustStoreType());
            }
        }
    }

    private static FileWatcher.Callback onFileChangeCallback(SslConfig sslConfig, SslContextFactory.Client sslContextFactory) {
        return () -> {
            ClientSslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, true, true);
            sslContextFactory.reload(scf -> log.info("SSL cert auto reload begun: " + scf.getKeyStorePath()));
            log.info("SSL cert auto reload complete");
        };
    }

    private static void configureSecurityProvider(SslContextFactory.Client sslContextFactory, SslConfig sslConfig) {
        sslContextFactory.setProvider(sslConfig.getProvider());
        if ("Conscrypt".equalsIgnoreCase(sslConfig.getProvider())) {
            Security.addProvider((Provider)new OpenSSLProvider());
        }
    }
}

