/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.confluent.rbacapi.rest.LeaderAwareApplication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.ee10.proxy.AsyncProxyServlet;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsWriterProxyServlet
extends AsyncProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(MdsWriterProxyServlet.class);
    private final LeaderAwareApplication application;
    private SslContextFactory sslContextFactory = new SslContextFactory.Client();

    public MdsWriterProxyServlet(LeaderAwareApplication application) {
        this.application = application;
    }

    @NotNull
    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = (SslContextFactory)Preconditions.checkNotNull((Object)sslContextFactory);
    }

    protected HttpClient newHttpClient() {
        ClientConnector clientConnector = new ClientConnector();
        int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
        String value = this.getServletConfig().getInitParameter("selectors");
        if (value != null) {
            selectors = Integer.parseInt(value);
        }
        clientConnector.setSelectors(selectors);
        if (this.sslContextFactory instanceof SslContextFactory.Client) {
            clientConnector.setSslContextFactory((SslContextFactory.Client)this.sslContextFactory);
        } else {
            clientConnector.setSslContextFactory(new SslContextFactory.Client());
        }
        HttpClientTransportDynamic transport = new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.setRequestBufferSize(8192);
        return client;
    }

    @VisibleForTesting
    public String rewriteTarget(HttpServletRequest clientRequest) {
        return this.extractProxyUri(clientRequest);
    }

    private String extractProxyUri(HttpServletRequest clientRequest) {
        int index;
        Object path = clientRequest.getRequestURI();
        String contextPath = clientRequest.getContextPath();
        String servletPath = clientRequest.getServletPath();
        if (contextPath != null && !contextPath.isEmpty() && ((String)path).contains(contextPath)) {
            index = ((String)path).indexOf(contextPath);
            path = ((String)path).substring(0, index) + ((String)path).substring(index + contextPath.length());
        }
        if (servletPath != null && !servletPath.isEmpty() && ((String)path).contains(servletPath)) {
            index = ((String)path).indexOf(servletPath);
            path = ((String)path).substring(0, index) + ((String)path).substring(index + servletPath.length());
        }
        if (path == null || !((String)path).startsWith("/")) {
            return null;
        }
        URL leader = this.getLeader(clientRequest.getScheme());
        if (leader == null) {
            try {
                HttpServletResponse response = (HttpServletResponse)clientRequest.getAttribute("jakarta.servlet.error.response");
                response.sendError(500, "Unable to determine leader. Try again later.");
                log.error("Unable to determine leader.");
            }
            catch (IOException e) {
                log.error(String.valueOf(e));
            }
            return null;
        }
        log.debug(String.format("Forwarding request for path %s to leader %s", path, leader));
        return UriBuilder.fromUri((String)leader.toString()).path((String)path).replaceQuery(clientRequest.getQueryString()).build(new Object[0]).toString();
    }

    private URL getLeader(String protocol) {
        return this.application.getLeader(protocol);
    }
}

