/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import io.confluent.common.security.auth.LeaderForwardChecker;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsWritesFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MdsWritesFilter.class);
    private final LeaderForwardChecker<HttpServletRequest> leaderForwardChecker;

    public MdsWritesFilter(LeaderForwardChecker<HttpServletRequest> leaderForwardChecker) {
        this.leaderForwardChecker = leaderForwardChecker;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.leaderForwardChecker.shouldForwardToLeader((Object)httpRequest)) {
            log.debug("Forwarding request: `" + httpRequest.getRequestURI() + "` to leader");
            request.getRequestDispatcher("/leader" + httpRequest.getRequestURI()).forward(request, response);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

