/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import io.confluent.common.security.auth.LeaderForwardChecker;
import io.confluent.rbacapi.rest.LeaderAwareApplication;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;

public class PathBasedLeaderForwardChecker
implements LeaderForwardChecker<HttpServletRequest> {
    private final LeaderAwareApplication application;
    private final Pattern pathsToForward = Pattern.compile("^/((\\d+\\.\\d+|v2alpha1)/(principals|acls|registry|oidc/authorization-code/callback|oidc/logout)).*");

    public PathBasedLeaderForwardChecker(LeaderAwareApplication application) {
        this.application = application;
    }

    public boolean shouldForwardToLeader(HttpServletRequest httpRequest) {
        String path = httpRequest.getPathInfo();
        return path != null && this.pathsToForward.matcher(path).matches() && !this.application.isLeader();
    }
}

