/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ClusterRegistryGatekeeper {
    private static final Operation ALTER_OP = new Operation("Alter");
    private static final Operation DESCRIBE_OP = new Operation("Describe");
    private static final Operation BOOTSTRAP_CLUSTER_OP = new Operation("BootstrapCluster");
    private static final ResourcePattern CLUSTER_REG_RP = new ResourcePattern(new ResourceType("ClusterRegistry"), "cluster-registry", PatternType.LITERAL);
    private final Authorizer authorizer;
    private final AuthCache authCache;
    private final Scope mdsScope;

    public ClusterRegistryGatekeeper(Authorizer authorizer, AuthCache authCache, String metadataClusterId) {
        this.authorizer = authorizer;
        this.authCache = authCache;
        this.mdsScope = Scope.kafkaClusterScope((String)metadataClusterId);
    }

    public List<Boolean> canWrite(KafkaPrincipal callingPrincipal, List<Scope> scopes) {
        if (this.hasBootstrapClusterAbility(callingPrincipal)) {
            return new ArrayList<Boolean>(Collections.nCopies(scopes.size(), true));
        }
        return this.authorizeScopeOperation(callingPrincipal, ALTER_OP, scopes);
    }

    public boolean canWrite(KafkaPrincipal callingPrincipal, Scope scope) {
        return this.canWrite(callingPrincipal, Collections.singletonList(scope)).get(0);
    }

    public List<ClusterInfo> filterClusterInfosBasedOnReadAuthorization(KafkaPrincipal callingPrincipal, List<ClusterInfo> clusterInfos) {
        ArrayList<ClusterInfo> results = new ArrayList<ClusterInfo>(clusterInfos.size());
        List<Boolean> authsFullClusterRead = this.canReadFullCluster(callingPrincipal, clusterInfos);
        ArrayList<ClusterInfo> toBeCheckedForRedactedRead = new ArrayList<ClusterInfo>(clusterInfos.size());
        for (int index = 0; index < clusterInfos.size(); ++index) {
            if (authsFullClusterRead.get(index).booleanValue()) {
                results.add(clusterInfos.get(index));
                continue;
            }
            toBeCheckedForRedactedRead.add(clusterInfos.get(index));
        }
        List redactedClusters = this.filterClustersWithRole(callingPrincipal, toBeCheckedForRedactedRead).stream().map(ClusterInfo::redact).collect(Collectors.toList());
        results.addAll(redactedClusters);
        return results;
    }

    private List<Boolean> canReadFullCluster(KafkaPrincipal callingPrincipal, List<ClusterInfo> clusters) {
        if (this.hasBootstrapClusterAbility(callingPrincipal)) {
            return new ArrayList<Boolean>(Collections.nCopies(clusters.size(), true));
        }
        List<Scope> scopes = clusters.stream().map(ClusterInfo::getScope).collect(Collectors.toList());
        return this.authorizeScopeOperation(callingPrincipal, DESCRIBE_OP, scopes);
    }

    private List<ClusterInfo> filterClustersWithRole(KafkaPrincipal callingPrincipal, List<ClusterInfo> clusters) {
        List scopes = clusters.stream().map(ClusterInfo::getScope).collect(Collectors.toList());
        Set roleAssingments = this.authCache.rbacRoleBindings(callingPrincipal, new HashSet(scopes));
        Set visibleScopes = roleAssingments.stream().map(RoleBinding::scope).collect(Collectors.toSet());
        return clusters.stream().filter(cluster -> visibleScopes.contains(cluster.getScope())).collect(Collectors.toList());
    }

    private boolean hasBootstrapClusterAbility(KafkaPrincipal callingPrincipal) {
        AuthorizeResult authAll = (AuthorizeResult)this.authorizer.authorize(callingPrincipal, "", Collections.singletonList(new Action(this.mdsScope, CLUSTER_REG_RP, BOOTSTRAP_CLUSTER_OP, 1, true, false))).get(0);
        return authAll == AuthorizeResult.ALLOWED;
    }

    private List<Boolean> authorizeScopeOperation(KafkaPrincipal callingPrincipal, Operation operation, List<Scope> scopes) {
        ArrayList<Action> actions = new ArrayList<Action>(scopes.size());
        for (Scope scope : scopes) {
            actions.add(new Action(scope, CLUSTER_REG_RP, operation));
        }
        List authResults = this.authorizer.authorize(callingPrincipal, "", actions);
        return authResults.stream().map(authorizeResult -> authorizeResult == AuthorizeResult.ALLOWED).collect(Collectors.toList());
    }
}

