/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClusterRegistryList {
    private final List<ClusterInfo> clusterList;
    private static V1ValidationUtil validationUtil = new V1ValidationUtil();

    public ClusterRegistryList(List<ClusterInfo> clusterInfos) {
        validationUtil.verifyClusterInfoList(clusterInfos);
        ArrayList<ClusterInfo> temp = new ArrayList<ClusterInfo>(clusterInfos);
        Collections.sort(temp);
        this.clusterList = temp;
    }

    public List<ClusterInfo> clusters() {
        return this.clusterList;
    }

    public List<ClusterInfo> clustersByType(ClusterType clusterType) {
        if (clusterType == null || clusterType == ClusterType.NOT_SPECIFIED) {
            return this.clusterList;
        }
        return this.clusterList.stream().filter(clusterInfo -> clusterType == ClusterType.of((Scope)clusterInfo.getScope())).collect(Collectors.toList());
    }

    public Optional<ClusterInfo> clustersByScope(Scope scope) {
        return this.clusterList.stream().filter(c -> scope.equals((Object)c.getScope())).findFirst();
    }

    public Optional<ClusterInfo> clusterByName(String name) {
        return this.clusterList.stream().filter(c -> c.getClusterName().equals(name)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRegistryList that = (ClusterRegistryList)o;
        return Objects.equals(this.clusterList, that.clusters());
    }

    public int hashCode() {
        return Objects.hash(this.clusterList);
    }
}

