/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.ConfluentAdmin;

public class ConfluentAdminClientFactory {
    public static final long ADMIN_CLIENT_CLOSE_TIMEOUT_MS = 10000L;

    private ConfluentAdminClientFactory() {
    }

    private static void closeClientWithTimeout(Runnable clientCloseTask, long timeoutMs) {
        Thread t = new Thread(clientCloseTask);
        t.setDaemon(true);
        t.start();
        try {
            t.join(timeoutMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.isAlive()) {
            t.interrupt();
        }
    }

    public static ConfluentAdmin createAdmin(AdminClientConfig adminClientConfigs) {
        return ConfluentAdmin.create(ConfluentAdminClientFactory.filterAdminClientConfigs(adminClientConfigs.values()));
    }

    public static ConfluentAdmin createAdmin(Map<String, Object> adminClientConfigs) {
        return ConfluentAdmin.create(ConfluentAdminClientFactory.filterAdminClientConfigs(adminClientConfigs));
    }

    public static void closeAdminClientWithTimeout(ConfluentAdmin adminClient) {
        ConfluentAdminClientFactory.closeAdminClientWithTimeout(adminClient, 10000L);
    }

    public static void closeAdminClientWithTimeout(ConfluentAdmin adminClient, long timeoutMs) {
        ConfluentAdminClientFactory.closeClientWithTimeout(() -> ((ConfluentAdmin)adminClient).close(), timeoutMs);
    }

    public static Map<String, Object> filterAdminClientConfigs(Map<String, ?> configs) {
        HashMap<String, Object> adminClientConfig = new HashMap<String, Object>(configs);
        Set validAdminClientProps = AdminClientConfig.configNames();
        adminClientConfig.keySet().retainAll(validAdminClientProps);
        adminClientConfig.remove("metric.reporters");
        return adminClientConfig;
    }
}

