/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.resources.v1;

import io.confluent.common.security.auth.entity.ImpersonateTokenRequest;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.tokenapi.entities.RefreshTokenRequest;
import io.confluent.tokenapi.entities.SanitizeTokenRequest;
import io.confluent.tokenapi.resources.base.TokenResource;
import io.confluent.tokenapi.services.TokenService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;

@Path(value="/1.0/")
@Produces(value={"application/json"})
public class V1TokenResource {
    private final TokenResource delegate;

    public V1TokenResource(TokenService tokenService) {
        this.delegate = new TokenResource(tokenService);
    }

    @GET
    @Path(value="authenticate")
    @PerformanceMetric(value="v1.authenticate")
    public Response issueToken(@Context SecurityContext auth, @Context HttpHeaders headers, @QueryParam(value="audience") List<String> aud) {
        return this.delegate.issueToken(auth, headers.getRequestHeaders(), aud);
    }

    @POST
    @Path(value="impersonate")
    @PerformanceMetric(value="v1.impersonate")
    public Response impersonateToken(@Context SecurityContext auth, @Context HttpServletRequest httpServletRequest, @QueryParam(value="audience") List<String> aud, ImpersonateTokenRequest impersonateTokenRequest) {
        return this.delegate.impersonateToken(auth, httpServletRequest, impersonateTokenRequest, aud);
    }

    @GET
    @Path(value="/token/clear")
    @PerformanceMetric(value="v1.token.clear")
    public Response clearToken() {
        return this.delegate.clearToken();
    }

    @POST
    @Path(value="token/refresh")
    @PerformanceMetric(value="v1.token.refresh")
    public Response refreshToken(@Context SecurityContext auth, RefreshTokenRequest refreshRequest) {
        return this.delegate.refreshToken(auth, refreshRequest);
    }

    @POST
    @Path(value="token/sanitize")
    @PerformanceMetric(value="v1.token.sanitize")
    public Response sanitizeToken(@Context SecurityContext auth, SanitizeTokenRequest sanitizeTokenRequest) {
        return this.delegate.sanitizeToken(auth, sanitizeTokenRequest);
    }
}

