/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.backupRestore.objectLifecycle.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TopicRetentionData
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static TopicRetentionData getRootAsTopicRetentionData(ByteBuffer _bb) {
        return TopicRetentionData.getRootAsTopicRetentionData(_bb, new TopicRetentionData());
    }

    public static TopicRetentionData getRootAsTopicRetentionData(ByteBuffer _bb, TopicRetentionData obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TopicRetentionData __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String topic() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer topicInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public int currentRetentionInDays() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public long ongoingReductionMinDeletionTimestamp() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public long reductionRecordTimestamp() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public String topicId() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer topicIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public static int createTopicRetentionData(FlatBufferBuilder builder, int topicOffset, int currentRetentionInDays, long ongoingReductionMinDeletionTimestamp, long reductionRecordTimestamp, int topicIdOffset) {
        builder.startTable(5);
        TopicRetentionData.addReductionRecordTimestamp(builder, reductionRecordTimestamp);
        TopicRetentionData.addOngoingReductionMinDeletionTimestamp(builder, ongoingReductionMinDeletionTimestamp);
        TopicRetentionData.addTopicId(builder, topicIdOffset);
        TopicRetentionData.addCurrentRetentionInDays(builder, currentRetentionInDays);
        TopicRetentionData.addTopic(builder, topicOffset);
        return TopicRetentionData.endTopicRetentionData(builder);
    }

    public static void startTopicRetentionData(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addTopic(FlatBufferBuilder builder, int topicOffset) {
        builder.addOffset(0, topicOffset, 0);
    }

    public static void addCurrentRetentionInDays(FlatBufferBuilder builder, int currentRetentionInDays) {
        builder.addInt(1, currentRetentionInDays, 0);
    }

    public static void addOngoingReductionMinDeletionTimestamp(FlatBufferBuilder builder, long ongoingReductionMinDeletionTimestamp) {
        builder.addLong(2, ongoingReductionMinDeletionTimestamp, -1L);
    }

    public static void addReductionRecordTimestamp(FlatBufferBuilder builder, long reductionRecordTimestamp) {
        builder.addLong(3, reductionRecordTimestamp, -1L);
    }

    public static void addTopicId(FlatBufferBuilder builder, int topicIdOffset) {
        builder.addOffset(4, topicIdOffset, 0);
    }

    public static int endTopicRetentionData(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TopicRetentionData get(int j) {
            return this.get(new TopicRetentionData(), j);
        }

        public TopicRetentionData get(TopicRetentionData obj, int j) {
            return obj.__assign(TopicRetentionData.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

