/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.provider;

import io.confluent.security.auth.client.RestClientConfig;
import io.confluent.security.auth.client.oauth.RefreshingAccessTokenRetriever;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import java.io.Closeable;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetrieverFactory;

public class HttpOauthBearerCredentialProvider
implements HttpCredentialProvider,
Closeable {
    private RefreshingAccessTokenRetriever oauthBearerTokenRetriever;

    @Override
    public String getProviderName() {
        return "OAUTHBEARER";
    }

    @Override
    public String getScheme() {
        return "Bearer";
    }

    @Override
    public String getCredentials() {
        return this.oauthBearerTokenRetriever.retrieve();
    }

    public void configure(Map<String, ?> configs) {
        this.oauthBearerTokenRetriever = new RefreshingAccessTokenRetriever(AccessTokenRetrieverFactory.create(this.retrieverConfig(configs), this.ConfigsToJaasMapper(configs)));
    }

    private Map<String, ?> retrieverConfig(Map<String, ?> configs) {
        RestClientConfig rbacClientConfig = new RestClientConfig(configs);
        return rbacClientConfig.saslClientConfigs();
    }

    private Map<String, Object> ConfigsToJaasMapper(Map<String, ?> configs) {
        RestClientConfig rbacClientConfig = new RestClientConfig(configs);
        Map<String, Object> jaasConfig = rbacClientConfig.sslClientConfigs();
        jaasConfig.put("clientId", rbacClientConfig.getString("confluent.metadata.oauthbearer.login.client.id"));
        if (rbacClientConfig.getPassword("confluent.metadata.oauthbearer.login.client.secret") != null) {
            jaasConfig.put("clientSecret", rbacClientConfig.getPassword("confluent.metadata.oauthbearer.login.client.secret").value());
        }
        jaasConfig.put("scope", rbacClientConfig.getString("confluent.metadata.oauthbearer.login.oauth.scope"));
        return jaasConfig;
    }

    @Override
    public void close() {
        this.oauthBearerTokenRetriever.close();
    }
}

