/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.ArrayUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class SortFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$sort");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$sort");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$sort");
    public static String ERR_FCTNOTFOUND = String.format("Cannot find a declared function as second argument of function \"%s\".", "$sort");
    public static String ERR_ARG1BADARRAYTYPE = String.format("Argument 1 of function \"%s\" must be an an array", "$sort");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = null;
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        boolean useContext = ctxEvalResult.useContext;
        if (argCount != 0 || arg != null) {
            if (argCount == 1) {
                if (arg == null || arg.isNull()) {
                    if (useContext) {
                        throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                    }
                } else if (arg.isArray()) {
                    result = JsonNodeFactory.instance.arrayNode();
                    ArrayNode array = (ArrayNode)arg;
                    for (JsonNode node : array) {
                        result.add(node);
                    }
                    this.msort(result, null, expressionVisitor, ctx);
                } else {
                    result = JsonNodeFactory.instance.arrayNode();
                    result.add(arg);
                }
            } else if (argCount == 2) {
                DeclaredFunction fct = null;
                if (arg == null) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                MappingExpressionParser.ExprContext fctCtx = ctx.exprValues().exprList().expr(useContext ? 0 : 1);
                if (fctCtx == null) {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
                if (!(fctCtx instanceof MappingExpressionParser.Function_declContext)) {
                    if (!(fctCtx instanceof MappingExpressionParser.Var_recallContext)) {
                        throw new EvaluateRuntimeException("Expected an function declaration reference but got " + fctCtx.getText() + " that is an " + ((Object)((Object)fctCtx)).getClass().getName());
                    }
                    String varID = ((MappingExpressionParser.Var_recallContext)fctCtx).VAR_ID().getText();
                    fct = expressionVisitor.getDeclaredFunction(varID);
                    if (fct == null) {
                        throw new EvaluateRuntimeException(String.format("Cannot find a declared function for variable \"%s\" of function \"%s\".", varID, "$sort"));
                    }
                } else {
                    MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)fctCtx;
                    MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
                    MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
                    try {
                        fct = new DeclaredFunction(varList, exprList);
                    }
                    catch (EvaluateRuntimeException e) {
                        throw new EvaluateRuntimeException(ERR_FCTNOTFOUND);
                    }
                }
                if (arg.isArray()) {
                    ArrayNode array = (ArrayNode)arg;
                    result = JsonNodeFactory.instance.arrayNode();
                    for (int i = 0; i < array.size(); ++i) {
                        result.add(array.get(i));
                    }
                    this.msort(result, fct, expressionVisitor, ctx);
                } else {
                    result = JsonNodeFactory.instance.arrayNode();
                    result.add(arg);
                }
            } else {
                throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<xf?:a>";
    }

    void msort(ArrayNode array, DeclaredFunction fct, ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx) {
        int n = array.size();
        if (array == null || n < 2) {
            return;
        }
        int middle = (int)Math.floor(n / 2);
        ArrayNode left = ArrayUtils.slice(array, 0, middle);
        ArrayNode right = ArrayUtils.slice(array, middle);
        this.msort(left, fct, exprVisitor, ctx);
        this.msort(right, fct, exprVisitor, ctx);
        this.merge(array, left, right, fct, exprVisitor, ctx);
    }

    void merge(ArrayNode array, ArrayNode left, ArrayNode right, DeclaredFunction fct, ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx) {
        int lSize = left.size();
        int rSize = right.size();
        int i = 0;
        int j = 0;
        int k = 0;
        if (fct == null) {
            while (i < lSize && j < rSize) {
                if (ArrayUtils.compare(left.get(i), right.get(j))) {
                    array.set(k++, right.get(j++));
                    continue;
                }
                array.set(k++, left.get(i++));
            }
            while (i < lSize) {
                array.set(k++, left.get(i++));
            }
            while (j < rSize) {
                array.set(k++, right.get(j++));
            }
        } else {
            int varCount = fct.getMaxArgs();
            while (i < lSize && j < rSize) {
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx.getParent(), ctx.invokingState);
                evc = FunctionUtils.fillExprVarContext(varCount, ctx, left.get(i), right.get(j));
                JsonNode comp = fct.invoke(exprVisitor, evc);
                if (comp != null && comp.asBoolean()) {
                    array.set(k++, right.get(j++));
                    continue;
                }
                array.set(k++, left.get(i++));
            }
            while (i < lSize) {
                array.set(k++, left.get(i++));
            }
            while (j < rSize) {
                array.set(k++, right.get(j++));
            }
        }
    }
}

