/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.rbac;

import io.confluent.connect.security.rbac.ActionBuilder;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.connect.security.util.ConnectRestUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;

class CreateConnectorActionBuilder
implements ActionBuilder {
    private final Scope scope;

    public CreateConnectorActionBuilder(Scope scope) {
        this.scope = scope;
    }

    @Override
    public List<Action> computeActions(ContainerRequestContext requestContext) throws IOException {
        CreateConnectorRequest createRequest = ConnectRestUtils.readEntity(requestContext, CreateConnectorRequest.class);
        String connectorName = createRequest.name();
        return Collections.singletonList(new Action(this.scope, ConnectActions.CONNECTOR_RESOURCE, connectorName, ConnectorOperations.CREATE));
    }
}

