/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.rbac;

import io.confluent.connect.security.rbac.ActionBuilder;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.util.ConnectRestUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class SimpleConnectorActionBuilder
implements ActionBuilder {
    private final Scope scope;
    private final List<Operation> operations;

    public SimpleConnectorActionBuilder(Scope scope, Operation ... operations) {
        this.scope = scope;
        this.operations = Arrays.asList(operations);
    }

    @Override
    public List<Action> computeActions(ContainerRequestContext requestContext) {
        String connectorName = ConnectRestUtils.connectorName(requestContext);
        return this.operations.stream().map(operation -> new Action(this.scope, ConnectActions.CONNECTOR_RESOURCE, connectorName, operation)).collect(Collectors.toList());
    }
}

