/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.entities.ErrorMessage;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class ConnectRestUtils {
    public static final TypeReference<Map<String, String>> CONNECTOR_CONFIG_TYPE = new TypeReference<Map<String, String>>(){};
    public static final String UNAUTHORIZED_OPERATION = "Unauthorized operation";
    public static final String UNAUTHENTICATED_USER = "User not authenticated";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String connectorName(ContainerRequestContext requestContext) {
        return (String)requestContext.getUriInfo().getPathParameters().getFirst((Object)"connector");
    }

    public static <T> T readEntity(ContainerRequestContext requestContext, TypeReference<T> type) throws IOException {
        return (T)OBJECT_MAPPER.readValue(ConnectRestUtils.body(requestContext), type);
    }

    public static <T> T readEntity(ContainerRequestContext requestContext, Class<T> klass) throws IOException {
        return (T)OBJECT_MAPPER.readValue(ConnectRestUtils.body(requestContext), klass);
    }

    public static <T> void setEntity(ContainerRequestContext requestContext, T entity) throws IOException {
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes(entity)));
    }

    public static <T> T responseEntity(ContainerResponseContext responseContext) {
        return (T)responseContext.getEntity();
    }

    private static byte[] body(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = requestContext.getEntityStream();){
            ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
        }
        byte[] result = out.toByteArray();
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(result));
        return result;
    }

    public static void abortRequest(ContainerRequestContext requestContext, Response.Status status, String message) {
        ErrorMessage entity = new ErrorMessage(status.getStatusCode(), message);
        requestContext.abortWith(Response.status((Response.Status)status).entity((Object)entity).build());
    }
}

