/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.single;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.SingleSource;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.operators.single.SingleToFlowable;
import io.confluent.shaded.io.reactivex.internal.operators.single.SingleToObservable;
import io.confluent.shaded.org.reactivestreams.Publisher;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;

public final class SingleInternalHelper {
    private SingleInternalHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Callable<NoSuchElementException> emptyThrower() {
        return NoSuchElementCallable.INSTANCE;
    }

    public static <T> Function<SingleSource<? extends T>, Publisher<? extends T>> toFlowable() {
        return ToFlowable.INSTANCE;
    }

    public static <T> Iterable<? extends Flowable<T>> iterableToFlowable(Iterable<? extends SingleSource<? extends T>> sources) {
        return new ToFlowableIterable(sources);
    }

    public static <T> Function<SingleSource<? extends T>, Observable<? extends T>> toObservable() {
        return ToObservable.INSTANCE;
    }

    static enum ToObservable implements Function<SingleSource, Observable>
    {
        INSTANCE;


        @Override
        public Observable apply(SingleSource v) {
            return new SingleToObservable(v);
        }
    }

    static final class ToFlowableIterable<T>
    implements Iterable<Flowable<T>> {
        private final Iterable<? extends SingleSource<? extends T>> sources;

        ToFlowableIterable(Iterable<? extends SingleSource<? extends T>> sources) {
            this.sources = sources;
        }

        @Override
        public Iterator<Flowable<T>> iterator() {
            return new ToFlowableIterator(this.sources.iterator());
        }
    }

    static final class ToFlowableIterator<T>
    implements Iterator<Flowable<T>> {
        private final Iterator<? extends SingleSource<? extends T>> sit;

        ToFlowableIterator(Iterator<? extends SingleSource<? extends T>> sit) {
            this.sit = sit;
        }

        @Override
        public boolean hasNext() {
            return this.sit.hasNext();
        }

        @Override
        public Flowable<T> next() {
            return new SingleToFlowable<T>(this.sit.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static enum ToFlowable implements Function<SingleSource, Publisher>
    {
        INSTANCE;


        @Override
        public Publisher apply(SingleSource v) {
            return new SingleToFlowable(v);
        }
    }

    static enum NoSuchElementCallable implements Callable<NoSuchElementException>
    {
        INSTANCE;


        @Override
        public NoSuchElementException call() throws Exception {
            return new NoSuchElementException();
        }
    }
}

